/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.windup.util.exception.WindupException;

public class ZipUtil {
    private static final Logger log = Logger.getLogger(ZipUtil.class.getName());
    private static Set<String> supportedExtensions;

    public static void unzipToFolder(File inputFile, File outputDir) throws IOException {
        if (inputFile == null) {
            throw new IllegalArgumentException("Argument inputFile is null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument outputDir is null.");
        }
        try (ZipFile zipFile = new ZipFile(inputFile);){
            Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
            while (entryEnum.hasMoreElements()) {
                ZipEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                File destFile = new File(outputDir, entryName);
                if (entry.isDirectory()) continue;
                File parentDir = destFile.getParentFile();
                if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                    throw new WindupException("Unable to create directory: " + parentDir.getAbsolutePath());
                }
                InputStream zipInputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream outputStream = new FileOutputStream(destFile);
                    Throwable throwable2 = null;
                    try {
                        Streams.write((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (zipInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    zipInputStream.close();
                }
            }
        }
    }

    public static File unzipToTemp(ZipFile file, ZipEntry entry) throws IOException {
        File file2;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            String entryExtension = StringUtils.substringAfterLast((String)entry.getName(), (String)".");
            File temp = new File(OperatingSystemUtils.getTempDirectory(), UUID.randomUUID().toString() + "." + entryExtension);
            in = file.getInputStream(entry);
            out = new FileOutputStream(temp);
            Streams.write((InputStream)in, (OutputStream)out);
            log.log(Level.INFO, "Extracting entry: " + entry.getName() + " to: " + temp.getAbsolutePath());
            file2 = temp;
        }
        catch (Exception e) {
            try {
                throw new IOException("Exception extracting entry: " + entry.getName(), e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(in);
                Streams.closeQuietly(out);
                throw throwable;
            }
        }
        Streams.closeQuietly((Closeable)in);
        Streams.closeQuietly((Closeable)out);
        return file2;
    }

    public static String getEndsWithZipRegularExpression() {
        String regex;
        Set<String> zipExtensions = ZipUtil.getZipExtensions();
        if (zipExtensions.size() == 1) {
            regex = ".+\\." + zipExtensions.iterator().next() + "$";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            for (String value : zipExtensions) {
                builder.append("|");
                builder.append(value);
            }
            builder.append(")\\b");
            regex = ".+\\." + builder.toString() + "$";
        }
        return regex;
    }

    public static boolean endsWithZipExtension(String path) {
        for (String extension : ZipUtil.getZipExtensions()) {
            if (!StringUtils.endsWith((String)path, (String)("." + extension))) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getZipExtensions() {
        if (supportedExtensions == null) {
            HashSet<String> extensions = new HashSet<String>();
            extensions.add("war");
            extensions.add("ear");
            extensions.add("jar");
            extensions.add("sar");
            extensions.add("rar");
            supportedExtensions = extensions;
        }
        return supportedExtensions;
    }
}

