/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.AbstractFaceted;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Callables;
import org.jboss.forge.furnace.util.Strings;

@Vetoed
public abstract class AbstractInputComponent<IMPLTYPE extends InputComponent<IMPLTYPE, VALUETYPE>, VALUETYPE>
extends AbstractFaceted<HintsFacet>
implements InputComponent<IMPLTYPE, VALUETYPE> {
    private final String name;
    private final char shortName;
    private final Class<VALUETYPE> type;
    private final Set<UIValidator> validators = new LinkedHashSet<UIValidator>();
    private final Set<ValueChangeListener> valueChangeListeners = new LinkedHashSet<ValueChangeListener>();
    private String label;
    private Callable<String> description;
    private Callable<Boolean> enabled = Callables.returning((Object)Boolean.TRUE);
    private Callable<Boolean> required = Callables.returning((Object)Boolean.FALSE);
    private String requiredMessage;
    private Converter<String, VALUETYPE> valueConverter;

    public AbstractInputComponent(String name, char shortName, Class<VALUETYPE> type) {
        Assert.notNull((Object)name, (String)"Name is required");
        this.name = name;
        this.shortName = shortName;
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public char getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return (String)Callables.call(this.description);
    }

    public Class<VALUETYPE> getValueType() {
        return this.type;
    }

    public boolean isEnabled() {
        return (Boolean)Callables.call(this.enabled);
    }

    public boolean isRequired() {
        return (Boolean)Callables.call(this.required);
    }

    public IMPLTYPE setEnabled(boolean enabled) {
        this.enabled = Callables.returning((Object)enabled);
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setEnabled(Callable<Boolean> callback) {
        this.enabled = callback;
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setLabel(String label) {
        this.label = label;
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setDescription(String description) {
        this.description = Callables.returning((Object)description);
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setDescription(Callable<String> description) {
        this.description = description;
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setRequired(boolean required) {
        this.required = Callables.returning((Object)required);
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setRequired(Callable<Boolean> required) {
        this.required = required;
        return (IMPLTYPE)((Object)this);
    }

    public boolean supports(HintsFacet type) {
        return true;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public IMPLTYPE setRequiredMessage(String requiredMessage) {
        this.requiredMessage = requiredMessage;
        return (IMPLTYPE)((Object)this);
    }

    public Converter<String, VALUETYPE> getValueConverter() {
        return this.valueConverter;
    }

    public IMPLTYPE setValueConverter(Converter<String, VALUETYPE> converter) {
        this.valueConverter = converter;
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE addValidator(UIValidator validator) {
        this.validators.add(validator);
        return (IMPLTYPE)((Object)this);
    }

    public Set<UIValidator> getValidators() {
        return Collections.unmodifiableSet(this.validators);
    }

    public void validate(UIValidationContext context) {
        String msg = InputComponents.validateRequired((InputComponent)this);
        if (!Strings.isNullOrEmpty((String)msg)) {
            context.addValidationError((InputComponent)this, msg);
        }
        if (this.hasValue() || this.hasDefaultValue()) {
            for (UIValidator validator : this.validators) {
                validator.validate(context);
            }
        }
    }

    public ListenerRegistration<ValueChangeListener> addValueChangeListener(final ValueChangeListener listener) {
        this.valueChangeListeners.add(listener);
        return new ListenerRegistration<ValueChangeListener>(){

            public ValueChangeListener removeListener() {
                AbstractInputComponent.this.valueChangeListeners.remove(listener);
                return listener;
            }
        };
    }

    protected Set<ValueChangeListener> getValueChangeListeners() {
        return this.valueChangeListeners;
    }

    protected void fireValueChangeListeners(Object newValue) {
        ValueChangeEvent evt = new ValueChangeEvent((InputComponent)this, this.getValue(), newValue);
        for (ValueChangeListener listener : this.getValueChangeListeners()) {
            listener.valueChanged(evt);
        }
    }
}

