/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.legacy;

import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.config.Classification;
import org.jboss.windup.reporting.config.Hint;
import org.jboss.windup.rules.apps.xml.condition.XmlFile;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderCustom;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderPerform;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.Context;

public class XmlJbossConfig
extends WindupRuleProvider {
    public void enhanceMetadata(Context context) {
        super.enhanceMetadata(context);
        context.put((Object)RuleMetadata.CATEGORY, (Object)"XML");
    }

    public Configuration getConfiguration(GraphContext context) {
        ConfigurationRuleBuilderCustom configurationRuleBuilderCustom = ConfigurationBuilder.begin().addRule().when((Condition)XmlFile.matchesXpath("//mbean[@code='org.jboss.cache.TreeCache']")).perform((Operation)Classification.as((String)"JBoss Cache").withEffort(1)).addRule().when((Condition)XmlFile.withDTDPublicId("JBoss.+DTD Java EE.+5")).perform((Operation)Classification.as((String)"JBoss 5.x EAR Descriptor").withEffort(0)).addRule().when((Condition)XmlFile.matchesXpath("/classloading")).perform((Operation)Classification.as((String)"JBoss Classloading").withEffort(1)).addRule().when((Condition)XmlFile.matchesXpath("/jbc:classloading").namespace("jbc", "urn:jboss:classloading:1.0")).perform((Operation)Classification.as((String)"JBoss Classloading Configuration").withEffort(0)).addRule().when((Condition)XmlFile.matchesXpath("/sc:components").namespace("sc", "http://jboss.com/products/seam/components")).perform((Operation)Classification.as((String)"JBoss Seam Components")).addRule().when((Condition)XmlFile.matchesXpath("/sp:pages").namespace("sp", "http://jboss.com/products/seam/pages")).perform((Operation)Classification.as((String)"JBoss Seam Pages")).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='jboss-app']").inFile("jboss-app.xml")).perform((Operation)Classification.as((String)"JBoss EAR Configuration").withEffort(1)).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='jboss-web']").inFile("jboss-web.xml")).perform((Operation)Classification.as((String)"JBoss Web Application Descriptor").withEffort(1)).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='classloading']").inFile("jboss-classloading.xml")).perform((Operation)Classification.as((String)"JBoss 5 Classloader Configuration")).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='jboss-deployment-structure']").inFile("jboss-deployment-structure.xml")).perform((Operation)Classification.as((String)"JBoss Module and Classloading Configuration (since AS7/EAP6)").withEffort(1)).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='jbosscmp-jdbc']").inFile("jbosscmp-jdbc.xml")).perform((Operation)Classification.as((String)"JBoss EJB2 CMP Deployment Descriptor")).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='jboss']").inFile("jboss.xml")).perform((Operation)Classification.as((String)"JBoss EJB Deployment Descriptor (prior to AS7/EAP6)").and((Operation)Classification.as((String)"If migrating to JBoss AS7 or EAP6 the &quot;jboss.xml&quot; descriptor is ignored in deployments. Replace with &quot;jboss-ejb3.xml&quot;").withEffort(1))).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='security-domain' ][starts-with(., 'java:/jaas/')]/text()")).perform((Operation)Hint.withText((String)"JBoss AS7/EAP6 Specific")).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='security-domain' ][starts-with(., 'java:/jaas/')]/text()").resultMatches("java\\:\\/jaas\\/")).perform((Operation)Hint.withText((String)"Remove the &quot;java:/jaas/&quot; prefix for security-domain elements in AS7/EAP6.").withEffort(1)).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='policy']").inFile("login-config.xml")).perform((Operation)Classification.as((String)"JBoss Security Configuration Descriptor (prior to AS7/EAP6)").and((Operation)Classification.as((String)"If migrating to JBoss AS7 or EAP6 the &quot;login-config.xml&quot; descriptor is no longer supported. Security is now configured in the security-domain element inside the server configuration.").withEffort(1))).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='ejb-jar']").inFile("jboss-ejb3.xml")).perform((Operation)Classification.as((String)"JBoss EJB3 Deployment Descriptor (since AS7/EAP6)")).addRule().when((Condition)XmlFile.matchesXpath("//*[local-name()='webservices']").inFile("jboss-webservices.xml")).perform((Operation)Classification.as((String)"JBoss Webservices Deployment Descriptor (since AS7/EAP6)")).addRule().when((Condition)XmlFile.matchesXpath("/page").inFile(".+.page.xml")).perform((Operation)Classification.as((String)"JBoss Seam Page")).addRule();
        ConditionBuilder conditionBuilder = XmlFile.matchesXpath("jboss-app").as("jboss-app");
        XmlFile.matchesXpath("jboss-app");
        ConfigurationRuleBuilderPerform configuration = configurationRuleBuilderCustom.when((Condition)conditionBuilder.and((Condition)XmlFile.withDTDPublicId("").as("jboss-app-no-DTD"))).perform((Operation)Iteration.over((String)"jboss-app").perform((Operation)Classification.as((String)"Jboss App Descriptor")).endIteration().and((Operation)Iteration.over((String)"jboss-app-no-DTD").perform((Operation)Classification.as((String)"Jboss App XML with missing DTD detect").withEffort(1)).endIteration()).and((Operation)Iteration.over((String)"jboss-app-no-DTD").perform((Operation)XSLTTransformation.using("transformations/xslt/jboss-app-to-jboss5.xsl").withDescription("JBoss APP Descriptor - JBoss 5 (Windup-Generated)").withExtension("-jboss5.xml")).endIteration())).addRule().when((Condition)XmlFile.matchesXpath("server/mbean[@code='org.jboss.mq.server.jmx.Queue']")).perform((Operation)Classification.as((String)"JBoss 4 JMS Configuration").withEffort(2).and((Operation)XSLTTransformation.using("transformations/xslt/jboss4-mq-to-jboss5.xsl").withDescription("Queue Destinations Service - JBoss 5 (Windup-Generated)").withExtension("-jboss5.xml")));
        return configuration;
    }
}

