/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.id;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertex;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertexIterable;

public class IdVertexIndex
implements Index<Vertex> {
    private final Index<Vertex> baseIndex;
    private final IdGraph idGraph;

    public IdVertexIndex(Index<Vertex> baseIndex, IdGraph idGraph) {
        if (null == baseIndex) {
            throw new IllegalArgumentException("null base index");
        }
        this.idGraph = idGraph;
        this.baseIndex = baseIndex;
    }

    @Override
    public String getIndexName() {
        return this.baseIndex.getIndexName();
    }

    @Override
    public Class<Vertex> getIndexClass() {
        return this.baseIndex.getIndexClass();
    }

    @Override
    public void put(String key, Object value, Vertex element) {
        this.baseIndex.put(key, value, this.getBaseElement(element));
    }

    @Override
    public CloseableIterable<Vertex> get(String key, Object value) {
        return new IdVertexIterable(this.baseIndex.get(key, value), this.idGraph);
    }

    @Override
    public CloseableIterable<Vertex> query(String key, Object query) {
        return new IdVertexIterable(this.baseIndex.query(key, query), this.idGraph);
    }

    @Override
    public long count(String key, Object value) {
        return this.baseIndex.count(key, value);
    }

    @Override
    public void remove(String key, Object value, Vertex element) {
        this.baseIndex.remove(key, value, this.getBaseElement(element));
    }

    private Vertex getBaseElement(Vertex e) {
        return (Vertex)((IdVertex)e).baseElement;
    }
}

