/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core;

import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IResource;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IBuffer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IJavaElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaModelException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ToolFactory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.WorkingCopyOwner;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.CharOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.util.IClassFileReader;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.BinaryType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.BufferManager;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClassFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Disassembler;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Util;

public class ClassFileWorkingCopy
extends CompilationUnit {
    public ClassFile classFile;

    public ClassFileWorkingCopy(ClassFile classFile, WorkingCopyOwner owner) {
        super((PackageFragment)classFile.getParent(), ((BinaryType)classFile.getType()).getSourceFileName(null), owner);
        this.classFile = classFile;
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.isWorkingCopy()) {
            return super.getBuffer();
        }
        return this.classFile.getBuffer();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException javaModelException) {
            return CharOperation.NO_CHAR;
        }
    }

    public IPath getPath() {
        return this.classFile.getPath();
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy(this.classFile, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IResource resource(PackageFragmentRoot root) {
        if (root.isArchive()) {
            return root.resource(root);
        }
        return this.classFile.resource(root);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = BufferManager.createBuffer(this);
        IBuffer classFileBuffer = this.classFile.getBuffer();
        if (classFileBuffer != null) {
            buffer.setContents(classFileBuffer.getCharacters());
        } else {
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
            Disassembler disassembler = new Disassembler();
            String contents = disassembler.disassemble(reader, Util.getLineSeparator("", this.getJavaProject()), 16);
            buffer.setContents(contents);
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.classFile.getElementName());
    }
}

