/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.IExtendedModifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.impl.AnnotationImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Types;

public class AnnotationAccessor<O extends JavaSource<O>, T> {
    public AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, ASTNode body) {
        return this.addAnnotation(target, this.getModifiers(body));
    }

    public AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, SingleVariableDeclaration variableDeclaration) {
        return this.addAnnotation(target, variableDeclaration.modifiers());
    }

    private AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, List<?> modifiers) {
        ListIterator<?> iter = modifiers.listIterator();
        while (iter.hasNext() && ((IExtendedModifier)iter.next()).isAnnotation()) {
        }
        if (iter.hasPrevious() && ((IExtendedModifier)iter.previous()).isAnnotation()) {
            iter.next();
        }
        AnnotationImpl<O, T> annotation = new AnnotationImpl<O, T>(target);
        iter.add((IExtendedModifier)annotation.getInternal());
        return annotation;
    }

    public AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, ASTNode body, Class<?> clazz) {
        return this.addAnnotation(target, this.getModifiers(body), clazz.getName());
    }

    public AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, SingleVariableDeclaration variableDeclaration, Class<?> clazz) {
        return this.addAnnotation(target, variableDeclaration.modifiers(), clazz.getName());
    }

    public AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, ASTNode body, String className) {
        return this.addAnnotation(target, this.getModifiers(body), className);
    }

    public AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, SingleVariableDeclaration variableDeclaration, String className) {
        return this.addAnnotation(target, variableDeclaration.modifiers(), className);
    }

    private AnnotationSource<O> addAnnotation(AnnotationTargetSource<O, T> target, List<?> modifiers, String className) {
        if (!((JavaSource)target.getOrigin()).hasImport(className) && Types.isQualified((String)className)) {
            ((JavaSource)target.getOrigin()).addImport(className);
        }
        return this.addAnnotation(target, modifiers).setName(Types.toSimpleName((String)className));
    }

    public List<AnnotationSource<O>> getAnnotations(AnnotationTargetSource<O, T> target, ASTNode body) {
        return this.getAnnotations(target, this.getModifiers(body));
    }

    public List<AnnotationSource<O>> getAnnotations(AnnotationTargetSource<O, T> target, SingleVariableDeclaration variableDeclaration) {
        return this.getAnnotations(target, variableDeclaration.modifiers());
    }

    private List<AnnotationSource<O>> getAnnotations(AnnotationTargetSource<O, T> target, List<?> modifiers) {
        ArrayList<AnnotationImpl<O, T>> result = new ArrayList<AnnotationImpl<O, T>>();
        for (Object object : modifiers) {
            if (!(object instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation)) continue;
            AnnotationImpl<O, T> annotation = new AnnotationImpl<O, T>(target, object);
            result.add(annotation);
        }
        return Collections.unmodifiableList(result);
    }

    public <E extends AnnotationTargetSource<O, T>> E removeAnnotation(E target, ASTNode body, Annotation<O> annotation) {
        return this.removeAnnotation(target, this.getModifiers(body), annotation);
    }

    public <E extends AnnotationTargetSource<O, T>> E removeAnnotation(E target, SingleVariableDeclaration variableDeclaration, Annotation<O> annotation) {
        return this.removeAnnotation(target, variableDeclaration.modifiers(), annotation);
    }

    private <E extends AnnotationTargetSource<O, T>> E removeAnnotation(E target, List<?> modifiers, Annotation<O> annotation) {
        for (Object object : modifiers) {
            if (!object.equals(annotation.getInternal())) continue;
            modifiers.remove(object);
            break;
        }
        return target;
    }

    public <E extends AnnotationTargetSource<O, T>> boolean hasAnnotation(E target, ASTNode body, String type) {
        return this.hasAnnotation(target, this.getModifiers(body), type);
    }

    public <E extends AnnotationTargetSource<O, T>> boolean hasAnnotation(E target, SingleVariableDeclaration variableDeclaration, String type) {
        return this.hasAnnotation(target, variableDeclaration.modifiers(), type);
    }

    private <E extends AnnotationTargetSource<O, T>> boolean hasAnnotation(E target, List<?> modifiers, String type) {
        for (Object object : modifiers) {
            AnnotationImpl annotation;
            String annotationType;
            if (!(object instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) || !Types.areEquivalent((String)type, (String)(annotationType = (annotation = new AnnotationImpl(target, object)).getName()))) continue;
            return true;
        }
        return false;
    }

    public AnnotationSource<O> getAnnotation(AnnotationTargetSource<O, T> target, ASTNode body, Class<? extends java.lang.annotation.Annotation> type) {
        return this.getAnnotation(target, this.getModifiers(body), type.getName());
    }

    public AnnotationSource<O> getAnnotation(AnnotationTargetSource<O, T> target, SingleVariableDeclaration variableDeclaration, Class<? extends java.lang.annotation.Annotation> type) {
        return this.getAnnotation(target, variableDeclaration.modifiers(), type.getName());
    }

    public AnnotationSource<O> getAnnotation(AnnotationTargetSource<O, T> target, ASTNode body, String type) {
        return this.getAnnotation(target, this.getModifiers(body), type);
    }

    public AnnotationSource<O> getAnnotation(AnnotationTargetSource<O, T> target, SingleVariableDeclaration variableDeclaration, String type) {
        return this.getAnnotation(target, variableDeclaration.modifiers(), type);
    }

    private AnnotationSource<O> getAnnotation(AnnotationTargetSource<O, T> target, List<?> modifiers, String type) {
        List<AnnotationSource<O>> annotations = this.getAnnotations(target, modifiers);
        for (AnnotationSource<O> annotation : annotations) {
            if (!Types.areEquivalent((String)type, (String)annotation.getName())) continue;
            return annotation;
        }
        return null;
    }

    private List<?> getModifiers(ASTNode body) {
        if (body instanceof BodyDeclaration) {
            return ((BodyDeclaration)body).modifiers();
        }
        if (body instanceof PackageDeclaration) {
            return ((PackageDeclaration)body).annotations();
        }
        return Collections.emptyList();
    }
}

