/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.WindupConfigurationOption;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.NullWindupProgressMonitor;
import org.jboss.windup.graph.GraphContext;

public class WindupConfiguration {
    private Predicate<WindupRuleProvider> ruleProviderFilter;
    private WindupProgressMonitor progressMonitor = new NullWindupProgressMonitor();
    private Map<String, Object> configurationOptions = new HashMap<String, Object>();
    private GraphContext context;

    public WindupConfiguration setOptionValue(String name, Object value) {
        this.configurationOptions.put(name, value);
        return this;
    }

    public <T> T getOptionValue(String name) {
        return (T)this.configurationOptions.get(name);
    }

    public Map<String, Object> getOptionMap() {
        return Collections.unmodifiableMap(this.configurationOptions);
    }

    public static Iterable<WindupConfigurationOption> getWindupConfigurationOptions() {
        ArrayList<WindupConfigurationOption> results = new ArrayList<WindupConfigurationOption>();
        for (WindupConfigurationOption option : FurnaceHolder.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(WindupConfigurationOption.class)) {
            results.add(option);
        }
        Collections.sort(results, new Comparator<WindupConfigurationOption>(){

            @Override
            public int compare(WindupConfigurationOption o1, WindupConfigurationOption o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return results;
    }

    public static Iterable<WindupConfigurationOption> getWindupConfigurationOptions(Addon addon) {
        IdentityHashMap<ClassLoader, Addon> classLoaderToAddon = new IdentityHashMap<ClassLoader, Addon>();
        for (Addon loadedAddon : FurnaceHolder.getAddonRegistry().getAddons()) {
            classLoaderToAddon.put(loadedAddon.getClassLoader(), loadedAddon);
        }
        ArrayList<WindupConfigurationOption> results = new ArrayList<WindupConfigurationOption>();
        Imported options = FurnaceHolder.getAddonRegistry().getServices(WindupConfigurationOption.class);
        for (WindupConfigurationOption option : options) {
            ClassLoader optionClassLoader = option.getClass().getClassLoader();
            Addon optionAddon = (Addon)classLoaderToAddon.get(optionClassLoader);
            if (!optionAddon.equals(addon)) continue;
            results.add(option);
        }
        return results;
    }

    public WindupConfiguration setInputPath(Path inputPath) {
        this.setOptionValue("input", inputPath.toFile());
        return this;
    }

    public Path getInputPath() {
        File file = (File)this.getOptionValue("input");
        return file == null ? null : file.toPath();
    }

    public Path getOutputDirectory() {
        File file = (File)this.getOptionValue("output");
        return file == null ? null : file.toPath();
    }

    public WindupConfiguration setOutputDirectory(Path outputDirectory) {
        this.setOptionValue("output", outputDirectory.toFile());
        return this;
    }

    public List<Path> getUserRulesDirectories() {
        List paths = (List)this.getOptionValue("userRulesDirectory");
        if (paths == null) {
            return Collections.emptyList();
        }
        return paths;
    }

    public WindupConfiguration setUserRulesDirectories(List<Path> userRulesDirectories) {
        this.setOptionValue("userRulesDirectory", userRulesDirectories);
        return this;
    }

    public WindupConfiguration addUserRulesDirectory(Path path) {
        ArrayList<Path> paths = (ArrayList<Path>)this.getOptionValue("userRulesDirectory");
        if (paths == null) {
            paths = new ArrayList<Path>();
            paths.add(path);
            return this;
        }
        for (Path existingPath : paths) {
            if (!existingPath.equals(path)) continue;
            return this;
        }
        paths.add(path);
        return this;
    }

    public Predicate<WindupRuleProvider> getRuleProviderFilter() {
        return this.ruleProviderFilter;
    }

    public WindupConfiguration setRuleProviderFilter(Predicate<WindupRuleProvider> ruleProviderFilter) {
        this.ruleProviderFilter = ruleProviderFilter;
        return this;
    }

    public WindupProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public WindupConfiguration setProgressMonitor(WindupProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        return this;
    }

    public WindupConfiguration setGraphContext(GraphContext context) {
        this.context = context;
        return this;
    }

    public GraphContext getGraphContext() {
        return this.context;
    }

    public WindupConfiguration setOffline(boolean offline) {
        this.setOptionValue("offline", offline);
        return this;
    }

    public boolean isOffline() {
        Boolean offline = (Boolean)this.getOptionValue("offline");
        return offline == null ? false : offline;
    }
}

