/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.modules;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.impl.addons.AddonStateManager;
import org.jboss.forge.furnace.impl.modules.AddonModuleIdentifierCache;
import org.jboss.forge.furnace.impl.modules.AddonModuleJarFileCache;
import org.jboss.forge.furnace.impl.modules.ModuleSpecProvider;
import org.jboss.forge.furnace.impl.modules.providers.CORBAClasspathSpec;
import org.jboss.forge.furnace.impl.modules.providers.FurnaceContainerSpec;
import org.jboss.forge.furnace.impl.modules.providers.JAXBJDKClasspathSpec;
import org.jboss.forge.furnace.impl.modules.providers.SunJDKClasspathSpec;
import org.jboss.forge.furnace.impl.modules.providers.SystemClasspathSpec;
import org.jboss.forge.furnace.impl.modules.providers.XATransactionJDKClasspathSpec;
import org.jboss.forge.furnace.impl.modules.providers.XPathJDKClasspathSpec;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public class AddonModuleLoader
extends ModuleLoader {
    private static final String CONTAINER_PREFIX = "org.jboss.forge.furnace.container:";
    private static final Logger logger = Logger.getLogger(AddonModuleLoader.class.getName());
    private Iterable<ModuleSpecProvider> moduleProviders;
    private final AddonModuleIdentifierCache moduleCache;
    private final AddonModuleJarFileCache moduleJarFileCache;
    private AddonLifecycleManager lifecycleManager;
    private AddonStateManager stateManager;
    private final ThreadLocal<Addon> currentAddon = new ThreadLocal();
    private Furnace furnace;

    public AddonModuleLoader(Furnace furnace, AddonLifecycleManager lifecycleManager, AddonStateManager stateManager) {
        this.furnace = furnace;
        this.lifecycleManager = lifecycleManager;
        this.stateManager = stateManager;
        this.moduleCache = new AddonModuleIdentifierCache();
        this.moduleJarFileCache = new AddonModuleJarFileCache();
        this.installModuleMBeanServer();
    }

    public void dispose() {
        this.furnace = null;
        this.lifecycleManager = null;
        this.stateManager = null;
        this.moduleCache.dispose();
        this.moduleJarFileCache.dispose();
        this.moduleProviders = null;
    }

    public final Module loadAddonModule(Addon addon) throws ModuleLoadException {
        try {
            Module result;
            this.currentAddon.set(addon);
            ModuleIdentifier moduleId = this.moduleCache.getModuleId(addon);
            Module module = result = this.loadModule(moduleId);
            return module;
        }
        catch (ModuleLoadException e) {
            throw e;
        }
        finally {
            this.currentAddon.remove();
        }
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module pluginModule = super.preloadModule(identifier);
        return pluginModule;
    }

    protected ModuleSpec findModule(ModuleIdentifier id) throws ModuleLoadException {
        ModuleSpec result = this.findRegularModule(id);
        if (result == null && this.currentAddon.get() != null) {
            result = this.findAddonModule(id);
        }
        return result;
    }

    private ModuleSpec findRegularModule(ModuleIdentifier id) {
        ModuleSpecProvider p;
        ModuleSpec result = null;
        Iterator<ModuleSpecProvider> i$ = this.getModuleProviders().iterator();
        while (i$.hasNext() && (result = (p = i$.next()).get(this, id)) == null) {
        }
        return result;
    }

    private Iterable<ModuleSpecProvider> getModuleProviders() {
        if (this.moduleProviders == null) {
            this.moduleProviders = ServiceLoader.load(ModuleSpecProvider.class, this.furnace.getRuntimeClassLoader());
        }
        return this.moduleProviders;
    }

    private ModuleSpec findAddonModule(ModuleIdentifier id) {
        Addon addon = this.currentAddon.get();
        if (addon != null) {
            Set<AddonView> views = this.stateManager.getViewsOf(addon);
            AddonId found = addon.getId();
            for (AddonRepository repository : views.iterator().next().getRepositories()) {
                Addon mappedAddon;
                if (!repository.isEnabled(found) || !repository.isDeployed(found) || (mappedAddon = this.moduleCache.getAddon(id)) == null || !mappedAddon.getId().equals((Object)found)) continue;
                ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)id);
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)SystemClasspathSpec.ID));
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)XPathJDKClasspathSpec.ID));
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)JAXBJDKClasspathSpec.ID));
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)CORBAClasspathSpec.ID));
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)SunJDKClasspathSpec.ID));
                ClassLoader parent = ClassLoader.getSystemClassLoader().getParent();
                if (parent != null) {
                    builder.addDependency(DependencySpec.createClassLoaderDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ClassLoader)parent, Collections.singleton("META-INF/services")));
                }
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)XATransactionJDKClasspathSpec.ID));
                builder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.rejectAll(), null, (ModuleIdentifier)FurnaceContainerSpec.ID, (boolean)false));
                try {
                    this.addContainerDependencies(views, repository, found, builder);
                }
                catch (ContainerException e) {
                    logger.warning(e.getMessage());
                    return null;
                }
                builder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll()));
                try {
                    this.addAddonDependencies(views, repository, found, builder);
                }
                catch (ContainerException e) {
                    logger.warning(e.getMessage());
                    return null;
                }
                this.addLocalResources(repository, found, builder, id);
                return builder.create();
            }
        }
        return null;
    }

    private void addLocalResources(AddonRepository repository, AddonId found, ModuleSpec.Builder builder, ModuleIdentifier id) {
        List resources = repository.getAddonResources(found);
        for (File file : resources) {
            try {
                if (file.isDirectory()) {
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createFileResourceLoader((String)file.getName(), (File)file), (PathFilter)PathFilters.acceptAll()));
                    continue;
                }
                if (file.length() <= 0L) continue;
                JarFile jarFile = new JarFile(file);
                this.moduleJarFileCache.addJarFileReference(id, jarFile);
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)file.getName(), (JarFile)jarFile), (PathFilter)PathFilters.acceptAll()));
            }
            catch (IOException e) {
                throw new ContainerException("Could not load resources from [" + file.getAbsolutePath() + "]", (Throwable)e);
            }
        }
    }

    private void addContainerDependencies(Set<AddonView> views, AddonRepository repository, AddonId found, ModuleSpec.Builder builder) throws ContainerException {
        Set addons = repository.getAddonDependencies(found);
        for (AddonDependencyEntry dependency : addons) {
            if (!dependency.getName().startsWith(CONTAINER_PREFIX)) continue;
            this.addAddonDependency(views, found, builder, dependency);
        }
    }

    private void addAddonDependencies(Set<AddonView> views, AddonRepository repository, AddonId found, ModuleSpec.Builder builder) throws ContainerException {
        Set addons = repository.getAddonDependencies(found);
        for (AddonDependencyEntry dependency : addons) {
            if (dependency.getName().startsWith(CONTAINER_PREFIX)) continue;
            this.addAddonDependency(views, found, builder, dependency);
        }
    }

    private void addAddonDependency(Set<AddonView> views, AddonId found, ModuleSpec.Builder builder, AddonDependencyEntry dependency) {
        AddonId addonId = this.stateManager.resolveAddonId(views, dependency.getName());
        ModuleIdentifier moduleId = null;
        if (addonId != null) {
            Addon addon = this.lifecycleManager.getAddon(views, addonId);
            moduleId = this.findCompatibleInstalledModule(addonId);
            if (moduleId != null) {
                builder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.not((PathFilter)PathFilters.getMetaInfFilter()), (PathFilter)(dependency.isExported() ? PathFilters.acceptAll() : PathFilters.rejectAll()), (ModuleLoader)this, (ModuleIdentifier)this.moduleCache.getModuleId(addon), (boolean)dependency.isOptional()));
            }
        }
        if (!(dependency.isOptional() || addonId != null && moduleId != null)) {
            throw new ContainerException("Dependency [" + dependency + "] could not be loaded for addon [" + found + "]");
        }
    }

    private ModuleIdentifier findCompatibleInstalledModule(AddonId addonId) {
        ModuleIdentifier result = null;
        Addon addon = this.currentAddon.get();
        Version runtimeAPIVersion = AddonRepositoryImpl.getRuntimeAPIVersion();
        block0: for (AddonRepository repository : this.stateManager.getViewsOf(addon).iterator().next().getRepositories()) {
            List enabled = repository.listEnabledCompatibleWithVersion(runtimeAPIVersion);
            for (AddonId id : enabled) {
                if (!id.getName().equals(addonId.getName())) continue;
                result = this.moduleCache.getModuleId(addon);
                continue block0;
            }
        }
        return result;
    }

    public String toString() {
        return "AddonModuleLoader";
    }

    public void releaseAddonModule(Addon addon) {
        ModuleIdentifier id = this.moduleCache.getModuleId(addon);
        this.moduleJarFileCache.closeJarFileReferences(id);
        Module loadedModule = this.findLoadedModuleLocal(id);
        if (loadedModule != null) {
            this.unloadModuleLocal(loadedModule);
        }
        this.moduleCache.clear(addon);
    }

    private void installModuleMBeanServer() {
        try {
            Method method = ModuleLoader.class.getDeclaredMethod("installMBeanServer", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Could not install Modules MBean server", (Throwable)e);
        }
    }
}

