/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.WindupConfigurationOption;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.ui.WindupProgressMonitorAdapter;
import org.jboss.windup.util.WindupPathUtil;

public class WindupCommand
implements UICommand {
    public static final String WINDUP_CONFIGURATION = "windupConfiguration";
    @Inject
    @WithAttributes(label="Overwrite", required=false, defaultValue="false", description="Force overwrite of the output directory, without prompting")
    private UIInput<Boolean> overwrite;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private WindupProcessor processor;
    private List<WindupOptionAndInput> inputOptions = new ArrayList<WindupOptionAndInput>();

    public UICommandMetadata getMetadata(UIContext ctx) {
        return Metadata.forCommand(this.getClass()).name("Windup Migrate App").description("Run Windup Migration Analyzer").category(Categories.create((String[])new String[]{"Platform", "Migration"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        for (WindupConfigurationOption option : WindupConfiguration.getWindupConfigurationOptions()) {
            UIInput inputComponent = null;
            switch (option.getUIType()) {
                case SINGLE: {
                    UIInput inputSingle;
                    inputComponent = inputSingle = this.componentFactory.createInput(option.getName(), option.getType());
                    break;
                }
                case MANY: {
                    UIInputMany inputMany = this.componentFactory.createInputMany(option.getName(), option.getType());
                    inputComponent = inputMany;
                    break;
                }
                case SELECT_MANY: {
                    UISelectMany selectMany = this.componentFactory.createSelectMany(option.getName(), option.getType());
                    inputComponent = selectMany;
                    break;
                }
                case SELECT_ONE: {
                    UISelectOne selectOne = this.componentFactory.createSelectOne(option.getName(), option.getType());
                    inputComponent = selectOne;
                    break;
                }
                case DIRECTORY: {
                    UIInput directoryInput;
                    inputComponent = directoryInput = this.componentFactory.createInput(option.getName(), DirectoryResource.class);
                    break;
                }
                case FILE: {
                    UIInput fileInput;
                    inputComponent = fileInput = this.componentFactory.createInput(option.getName(), FileResource.class);
                    break;
                }
                case FILE_OR_DIRECTORY: {
                    UIInput fileOrDirInput;
                    inputComponent = fileOrDirInput = this.componentFactory.createInput(option.getName(), FileResource.class);
                }
            }
            if (inputComponent == null) {
                throw new IllegalArgumentException("Could not build input component for: " + option);
            }
            inputComponent.setLabel(option.getLabel());
            inputComponent.setRequired(option.isRequired());
            inputComponent.setDescription(option.getDescription());
            builder.add((InputComponent)inputComponent);
            this.inputOptions.add(new WindupOptionAndInput(option, (InputComponent<?, ?>)inputComponent));
        }
        builder.add(this.overwrite);
    }

    public void validate(UIValidationContext context) {
        for (WindupOptionAndInput pair : this.inputOptions) {
            Object value = this.getValueForInput(pair.input);
            ValidationResult result = pair.option.validate(value);
            if (result.isSuccess()) continue;
            context.addValidationError(pair.input, result.getMessage());
        }
    }

    private Object getValueForInput(InputComponent<?, ?> input) {
        Object value = input.getValue();
        if (value == null) {
            return value;
        }
        if (value instanceof Resource) {
            return ((Resource)value).getUnderlyingResourceObject();
        }
        return value;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        for (WindupOptionAndInput pair : this.inputOptions) {
            String key = pair.option.getName();
            Object value = this.getValueForInput(pair.input);
            windupConfiguration.setOptionValue(key, value);
        }
        Path userRulesDir = WindupPathUtil.getWindupUserRulesDir();
        windupConfiguration.addUserRulesDirectory(userRulesDir);
        Path windupHomeRulesDir = WindupPathUtil.getWindupHomeRules();
        windupConfiguration.addUserRulesDirectory(windupHomeRulesDir);
        boolean overwrite = (Boolean)this.overwrite.getValue();
        if (!overwrite && this.pathNotEmpty(windupConfiguration.getOutputDirectory().toFile())) {
            String promptMsg = "Overwrite all contents of \"" + windupConfiguration.getOutputDirectory().toString() + "\" (anything already in the directory will be deleted)?";
            if (!context.getPrompt().promptBoolean(promptMsg)) {
                return Results.fail((String)"Windup execution aborted!");
            }
        }
        FileUtils.deleteQuietly((File)windupConfiguration.getOutputDirectory().toFile());
        Path graphPath = windupConfiguration.getOutputDirectory().resolve("graph");
        try (GraphContext graphContext = this.graphContextFactory.create(graphPath);){
            UIProgressMonitor uiProgressMonitor = context.getProgressMonitor();
            WindupProgressMonitorAdapter progressMonitor = new WindupProgressMonitorAdapter(uiProgressMonitor);
            windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitor).setGraphContext(graphContext);
            this.processor.execute(windupConfiguration);
            uiProgressMonitor.done();
            Result result = Results.success((String)("Windup report created: " + windupConfiguration.getOutputDirectory().toAbsolutePath() + "/index.html"));
            return result;
        }
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }

    private class WindupOptionAndInput {
        private WindupConfigurationOption option;
        private InputComponent<?, ?> input;

        public WindupOptionAndInput(WindupConfigurationOption option, InputComponent<?, ?> input) {
            this.option = option;
            this.input = input;
        }
    }
}

