/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.FastNoSuchElementException;
import com.tinkerpop.pipes.util.structures.ArrayQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class AggregatePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe.GreedySideEffectPipe<S, Collection> {
    private Collection aggregate;
    private Queue<S> currentObjectQueue = new ArrayQueue<S>();
    private Queue<List> currentPathQueue = new ArrayQueue<List>();
    private List currentPath;
    private PipeFunction<S, ?> preAggregateFunction = null;

    public AggregatePipe(Collection aggregate) {
        this.aggregate = aggregate;
    }

    public AggregatePipe(Collection aggregate, PipeFunction<S, ?> preAggregateFunction) {
        this(aggregate);
        this.preAggregateFunction = preAggregateFunction;
    }

    @Override
    public List getCurrentPath() {
        if (this.pathEnabled) {
            ArrayList<Object> pathElements = new ArrayList<Object>(this.currentPath);
            int size = pathElements.size();
            if (size == 0 || pathElements.get(size - 1) != this.currentEnd) {
                pathElements.add(this.currentEnd);
            }
            return pathElements;
        }
        throw new RuntimeException("Path calculations are not enabled");
    }

    @Override
    protected S processNextStart() {
        while (this.currentObjectQueue.isEmpty()) {
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            this.currentObjectQueue.clear();
            this.currentPathQueue.clear();
            try {
                while (true) {
                    Object s = this.starts.next();
                    if (this.preAggregateFunction != null) {
                        this.aggregate.add(this.preAggregateFunction.compute(s));
                    } else {
                        this.aggregate.add(s);
                    }
                    this.currentObjectQueue.add(s);
                    if (!this.pathEnabled) continue;
                    this.currentPathQueue.add(this.getPathToHere());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        if (this.pathEnabled) {
            this.currentPath = this.currentPathQueue.remove();
        }
        return this.currentObjectQueue.remove();
    }

    @Override
    public Collection getSideEffect() {
        return this.aggregate;
    }

    @Override
    public void reset() {
        try {
            this.aggregate = (Collection)this.aggregate.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.currentPath = null;
        this.currentObjectQueue.clear();
        this.currentPathQueue.clear();
        super.reset();
    }
}

