/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParserException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XMLParser {
    public static InputStream toXMLInputStream(Node node) {
        return new ByteArrayInputStream(XMLParser.toXMLByteArray(node));
    }

    public static String toXMLString(Node node) {
        return new String(XMLParser.toXMLByteArray(node));
    }

    public static byte[] toXMLByteArray(Node node) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document root = builder.newDocument();
            XMLParser.writeRecursive(root, node);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            transformer.transform(new DOMSource(root), result);
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw new XMLParserException("Could not export Node strcuture to XML", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node parse(File file) throws XMLParserException, FileNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Node node = XMLParser.parse(new BufferedInputStream(fis, 2048));
            return node;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Node parse(byte[] xml) {
        return XMLParser.parse(new ByteArrayInputStream(xml));
    }

    public static Node parse(String xml) {
        return XMLParser.parse(xml.getBytes());
    }

    public static Node parse(InputStream stream) throws XMLParserException {
        try {
            if (stream.available() == 0) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Node root = new Node(doc.getDocumentElement().getNodeName());
            XMLParser.readRecursive(root, doc.getDocumentElement());
            return root;
        }
        catch (Exception e) {
            throw new XMLParserException("Could not import XML from stream", e);
        }
    }

    private static void readRecursive(Node target, org.w3c.dom.Node source) {
        XMLParser.readAttributes(target, source);
        NodeList sourceChildren = source.getChildNodes();
        if (sourceChildren != null) {
            for (int i = 0; i < sourceChildren.getLength(); ++i) {
                org.w3c.dom.Node child = sourceChildren.item(i);
                if (child.getNodeType() == 3) continue;
                Node newTarget = target.createChild(child.getNodeName());
                if (XMLParser.onlyTextChildren(child)) {
                    if (child.getNodeType() == 8) {
                        newTarget.setComment(true);
                    }
                    newTarget.text(child.getTextContent());
                    XMLParser.readAttributes(newTarget, child);
                    continue;
                }
                XMLParser.readRecursive(newTarget, child);
            }
        }
    }

    private static void writeRecursive(org.w3c.dom.Node target, Node source) {
        org.w3c.dom.Node targetChild;
        Document owned = target.getOwnerDocument();
        if (owned == null) {
            owned = (Document)target;
        }
        if (NodeType.COMMENT.getNodeName().equals(source.getName())) {
            targetChild = owned.createComment(source.getText());
        } else if (NodeType.CDATA_SECTION.getNodeName().equals(source.getName())) {
            targetChild = owned.createCDATASection(source.getText());
        } else {
            targetChild = owned.createElement(source.getName());
            if (source.getText() != null) {
                targetChild.appendChild(owned.createTextNode(source.getText()));
            }
        }
        target.appendChild(targetChild);
        for (Map.Entry<String, String> attribute : source.getAttributes().entrySet()) {
            Attr attr = owned.createAttribute(attribute.getKey());
            attr.setValue(attribute.getValue());
            targetChild.getAttributes().setNamedItem(attr);
        }
        for (Node sourceChild : source.getChildren()) {
            XMLParser.writeRecursive(targetChild, sourceChild);
        }
    }

    private static void readAttributes(Node target, org.w3c.dom.Node source) {
        NamedNodeMap attributes = source.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                org.w3c.dom.Node attribute = attributes.item(i);
                target.attribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
    }

    private static boolean onlyTextChildren(org.w3c.dom.Node source) {
        NodeList children = source.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() == 3) continue;
            return false;
        }
        return true;
    }

    public static enum NodeType {
        COMMENT("#comment"),
        CDATA_SECTION("#cdata-section");

        private final String nodeName;

        private NodeType(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

