/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.furnace.versions.DefaultVersionRange;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.VersionException;
import org.jboss.forge.furnace.versions.VersionRange;

public class MultipleVersionRange
implements VersionRange {
    private final List<VersionRange> ranges;

    public MultipleVersionRange(VersionRange ... ranges) {
        this(Arrays.asList(ranges));
    }

    MultipleVersionRange(List<VersionRange> ranges) {
        this.ranges = ranges;
    }

    public List<VersionRange> getRanges() {
        return this.ranges;
    }

    public MultipleVersionRange cloneOf() {
        ArrayList<VersionRange> copiedRanges = null;
        if (this.ranges != null) {
            copiedRanges = new ArrayList<VersionRange>();
            if (!this.ranges.isEmpty()) {
                copiedRanges.addAll(this.ranges);
            }
        }
        return new MultipleVersionRange(copiedRanges);
    }

    public MultipleVersionRange intersect(MultipleVersionRange intersection) {
        List<VersionRange> r1 = this.ranges;
        List<VersionRange> r2 = intersection.ranges;
        List<Object> ranges = r1.isEmpty() || r2.isEmpty() ? Collections.emptyList() : this.intersection(r1, r2);
        if (ranges.isEmpty()) {
            throw new VersionException("Intersected incompatible version ranges");
        }
        return new MultipleVersionRange(ranges);
    }

    private List<VersionRange> intersection(List<VersionRange> r1, List<VersionRange> r2) {
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>(r1.size() + r2.size());
        Iterator<VersionRange> i1 = r1.iterator();
        Iterator<VersionRange> i2 = r2.iterator();
        VersionRange res1 = i1.next();
        VersionRange res2 = i2.next();
        boolean done = false;
        while (!done) {
            if (res1.getMin() == null || res2.getMax() == null || res1.getMin().compareTo(res2.getMax()) <= 0) {
                if (res1.getMax() == null || res2.getMin() == null || res1.getMax().compareTo(res2.getMin()) >= 0) {
                    boolean maxInclusive;
                    Version max;
                    int comparison;
                    boolean minInclusive;
                    Version min;
                    if (res1.getMin() == null) {
                        min = res2.getMin();
                        minInclusive = res2.isMinInclusive();
                    } else if (res2.getMin() == null) {
                        min = res1.getMin();
                        minInclusive = res1.isMinInclusive();
                    } else {
                        comparison = res1.getMin().compareTo(res2.getMin());
                        if (comparison < 0) {
                            min = res2.getMin();
                            minInclusive = res2.isMinInclusive();
                        } else if (comparison == 0) {
                            min = res1.getMin();
                            minInclusive = res1.isMinInclusive() && res2.isMinInclusive();
                        } else {
                            min = res1.getMin();
                            minInclusive = res1.isMinInclusive();
                        }
                    }
                    if (res1.getMax() == null) {
                        max = res2.getMax();
                        maxInclusive = res2.isMaxInclusive();
                    } else if (res2.getMax() == null) {
                        max = res1.getMax();
                        maxInclusive = res1.isMaxInclusive();
                    } else {
                        comparison = res1.getMax().compareTo(res2.getMax());
                        if (comparison < 0) {
                            max = res1.getMax();
                            maxInclusive = res1.isMaxInclusive();
                        } else if (comparison == 0) {
                            max = res1.getMax();
                            maxInclusive = res1.isMaxInclusive() && res2.isMaxInclusive();
                        } else {
                            max = res2.getMax();
                            maxInclusive = res2.isMaxInclusive();
                        }
                    }
                    if (min == null || max == null || min.compareTo(max) != 0) {
                        ranges.add(new DefaultVersionRange(min, minInclusive, max, maxInclusive));
                    } else if (minInclusive && maxInclusive) {
                        ranges.add(new DefaultVersionRange(min, minInclusive, max, maxInclusive));
                    }
                    if (max == res2.getMax()) {
                        if (i2.hasNext()) {
                            res2 = i2.next();
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    if (i1.hasNext()) {
                        res1 = i1.next();
                        continue;
                    }
                    done = true;
                    continue;
                }
                if (i1.hasNext()) {
                    res1 = i1.next();
                    continue;
                }
                done = true;
                continue;
            }
            if (i2.hasNext()) {
                res2 = i2.next();
                continue;
            }
            done = true;
        }
        return ranges;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Iterator<VersionRange> i = this.ranges.iterator();
        while (i.hasNext()) {
            VersionRange r = i.next();
            buf.append(r.toString());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public Version getHighestMatch(List<Version> versions) {
        Version matched = null;
        for (Version version : versions) {
            if (!this.includes(version) || matched != null && version.compareTo(matched) <= 0) continue;
            matched = version;
        }
        return matched;
    }

    public Version matchLowestMatch(List<Version> versions) {
        Version matched = null;
        for (Version version : versions) {
            if (!this.includes(version) || matched != null && version.compareTo(matched) <= 0) continue;
            matched = version;
        }
        return matched;
    }

    @Override
    public boolean includes(Version version) {
        for (VersionRange range : this.ranges) {
            if (!range.includes(version)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultipleVersionRange)) {
            return false;
        }
        MultipleVersionRange other = (MultipleVersionRange)obj;
        boolean equals = this.ranges == other.ranges || this.ranges != null && this.ranges.equals(other.ranges);
        return equals;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.ranges == null ? 0 : this.ranges.hashCode());
        return hash;
    }

    @Override
    public Version getMin() {
        VersionRange min = null;
        for (VersionRange range : this.ranges) {
            if (min != null && range.getMin().compareTo(min.getMin()) >= 0) continue;
            min = range;
        }
        return min == null ? null : min.getMin();
    }

    @Override
    public boolean isMinInclusive() {
        VersionRange min = null;
        for (VersionRange range : this.ranges) {
            if (min != null && range.getMin().compareTo(min.getMin()) >= 0) continue;
            min = range;
        }
        return min == null ? false : min.isMinInclusive();
    }

    @Override
    public Version getMax() {
        VersionRange max = null;
        for (VersionRange range : this.ranges) {
            if (max != null && range.getMax().compareTo(max.getMax()) <= 0) continue;
            max = range;
        }
        return max == null ? null : max.getMax();
    }

    @Override
    public boolean isMaxInclusive() {
        VersionRange max = null;
        for (VersionRange range : this.ranges) {
            if (max != null && range.getMax().compareTo(max.getMax()) <= 0) continue;
            max = range;
        }
        return max == null ? false : max.isMaxInclusive();
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public boolean isExact() {
        VersionRange seen = null;
        for (VersionRange range : this.ranges) {
            if (range.isExact()) {
                if (seen == null) {
                    seen = range;
                    continue;
                }
                if (seen.equals(range) || seen.isEmpty()) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public VersionRange getIntersection(VersionRange ... ranges) {
        return this.intersect(new MultipleVersionRange(ranges));
    }
}

