/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command.transaction;

import javax.inject.Inject;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.transaction.ResourceTransaction;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class TransactionRollbackCommand
extends AbstractShellCommand {
    @Inject
    ResourceFactory resourceFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("transaction-rollback").description("Rollbacks a transaction");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public boolean isEnabled(ShellContext context) {
        return super.isEnabled(context) && this.resourceFactory.getTransaction().isStarted();
    }

    public Result execute(UIExecutionContext shellContext) throws Exception {
        ResourceTransaction transaction = this.resourceFactory.getTransaction();
        if (!transaction.isStarted()) {
            return Results.fail((String)"Resource Transaction is not started");
        }
        transaction.rollback();
        return Results.success((String)"Resource Transaction was rolled back");
    }
}

