/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.lang.reflect.Method;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.transaction.xa.XAResource;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpoint;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpointFactory;
import org.xadisk.bridge.server.conversation.GlobalHostedContext;
import org.xadisk.connector.inbound.FileSystemEventListener;
import org.xadisk.connector.inbound.LocalEventProcessingXAResource;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeXAFileSystem;

public class FileSystemEventProcessor
implements Work {
    private final MessageEndpointFactory mef;
    private final FileSystemStateChangeEvent event;
    private final NativeXAFileSystem xaFileSystem;

    FileSystemEventProcessor(MessageEndpointFactory mef, FileSystemStateChangeEvent event, NativeXAFileSystem xaFileSystem) {
        this.mef = mef;
        this.event = event;
        this.xaFileSystem = xaFileSystem;
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Class[] classArray;
        LocalEventProcessingXAResource epXAR = new LocalEventProcessingXAResource(this.xaFileSystem, this.event);
        MessageEndpoint mep = null;
        try {
            while (mep == null) {
                try {
                    mep = this.mef.createEndpoint((XAResource)epXAR);
                }
                catch (UnavailableException uae) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        if (epXAR.getTransactionOutcome() == 3) return;
                        try {
                            this.xaFileSystem.getDeadLetter().dumpAndCommitMessage(this.event, epXAR);
                            return;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        return;
                    }
                }
            }
            classArray = new Class[]{FileSystemStateChangeEvent.class};
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        Method methodToInvoke = FileSystemEventListener.class.getMethod("onFileSystemEvent", classArray);
        mep.beforeDelivery(methodToInvoke);
        methodToInvoke.invoke((Object)mep, this.event);
        mep.afterDelivery();
        if (this.mef instanceof RemoteMessageEndpointFactory) {
            GlobalHostedContext globalCallbackContext = this.xaFileSystem.getGlobalCallbackContext();
            globalCallbackContext.deHostObject(epXAR);
        }
        mep.release();
        if (!(mep instanceof RemoteMessageEndpoint)) return;
        RemoteMessageEndpoint remoteMEP = (RemoteMessageEndpoint)mep;
        remoteMEP.shutdown();
        return;
        finally {
            if (epXAR.getTransactionOutcome() != 3) {
                try {
                    this.xaFileSystem.getDeadLetter().dumpAndCommitMessage(this.event, epXAR);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

