/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.transaction.file;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AvailableInputStreamWrapper
extends FilterInputStream {
    private final int initialAvailable;
    private volatile boolean streamRead;

    protected AvailableInputStreamWrapper(InputStream in, int available) {
        super(in);
        this.initialAvailable = available;
    }

    @Override
    public int available() throws IOException {
        if (this.streamRead) {
            return super.available();
        }
        return this.initialAvailable;
    }

    @Override
    public int read() throws IOException {
        this.streamRead = true;
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.streamRead = true;
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.streamRead = true;
        return super.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.streamRead = true;
        super.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.streamRead = true;
        return super.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.streamRead = true;
        super.mark(readlimit);
    }
}

