/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.txn.Locker;
import java.util.Date;

public abstract class StateChangeException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final StateChangeEvent stateChangeEvent;

    protected StateChangeException(Locker locker, StateChangeEvent stateChangeEvent) {
        super(locker, locker != null, StateChangeException.makeMessage(stateChangeEvent), null);
        this.stateChangeEvent = stateChangeEvent;
    }

    protected StateChangeException(String message, Exception reason) {
        super(null, false, message, reason);
        this.stateChangeEvent = null;
    }

    public StateChangeEvent getEvent() {
        return this.stateChangeEvent;
    }

    private static String makeMessage(StateChangeEvent event) {
        return event != null ? "The current state is:" + (Object)((Object)event.getState()) + "." + " The node transitioned to this state at:" + new Date(event.getEventTime()) : "Node state inconsistent with operation";
    }

    protected StateChangeException(String message, StateChangeException cause) {
        super(message, cause);
        this.stateChangeEvent = cause != null ? cause.stateChangeEvent : null;
    }
}

