/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text.highlight.scanner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.forge.addon.text.highlight.Encoder;
import org.jboss.forge.addon.text.highlight.Scanner;
import org.jboss.forge.addon.text.highlight.StringScanner;
import org.jboss.forge.addon.text.highlight.TokenType;
import org.jboss.forge.addon.text.highlight.WordList;
import org.jboss.forge.addon.text.highlight.scanner.java.BuiltInTypes;

public class JavaScanner
implements Scanner {
    public static final Pattern SPACE = Pattern.compile("\\s+|\\n");
    public static final Pattern COMMENT = Pattern.compile("// [^\\n\\\\]* (?: \\\\. [^\\n\\\\]* )* | /\\* (?: .*? \\*/ | .* )", 36);
    public static final Pattern IDENT = Pattern.compile("[a-zA-Z_][A-Za-z_0-9]*");
    public static final Pattern OPERATORS = Pattern.compile("\\.(?!\\d)|[,?:()\\[\\]}]|--|\\+\\+|&&|\\|\\||\\*\\*=?|[-+*\\/%^~&|<>=!]=?|<<<?=?|>>>?=?");
    public static final Pattern STRING_CONTENT_PATTERN_SINGLE = Pattern.compile("[^\\\\']+");
    public static final Pattern STRING_CONTENT_PATTERN_DOUBLE = Pattern.compile("[^\\\\\"]+");
    public static final Pattern STRING_CONTENT_PATTERN_MULTI_LINE = Pattern.compile("[^\\\\\\/]+");
    public static final Pattern ESCAPE = Pattern.compile("[bfnrtv\\n\\\\'\"]|x[a-fA-F0-9]{1,2}|[0-7]{1,3}");
    public static final Pattern UNICODE_ESCAPE = Pattern.compile("u[a-fA-F0-9]{4}|U[a-fA-F0-9]{8}");
    public static final Pattern ANNOTATION = Pattern.compile("@" + IDENT.pattern());
    public static final Pattern PACKAGE = Pattern.compile(IDENT.pattern() + "(?:\\." + IDENT.pattern() + ")*");
    public static final Pattern IDENT_OR_ARRAY_TYPE = Pattern.compile(IDENT.pattern() + "|\\[\\]");
    public static final Pattern SEMI_COLON = Pattern.compile(";");
    public static final Pattern OPEN_BRAKCET = Pattern.compile("\\{");
    public static final Pattern ANY_WORD = Pattern.compile("[\\d.]");
    public static final Pattern HEX = Pattern.compile("0[xX][0-9A-Fa-f]+");
    public static final Pattern OCTAL = Pattern.compile("(?>0[0-7]+)(?![89.eEfF])");
    public static final Pattern FLOAT = Pattern.compile("\\d+[fFdD]|\\d*\\.\\d+(?:[eE][+-]?\\d+)?[fFdD]?|\\d+[eE][+-]?\\d+[fFdD]?");
    public static final Pattern INTEGER = Pattern.compile("\\d+[lL]?");
    public static final Pattern START_STRING = Pattern.compile("[\"']");
    public static final Pattern END_STRING = Pattern.compile("[\"'\\/]");
    public static final Pattern STRING_CONTENT = Pattern.compile("\\\\(?:" + ESCAPE.pattern() + "|" + UNICODE_ESCAPE.pattern() + ")", 32);
    public static final Pattern STRING_CONTENT_2 = Pattern.compile("\\\\.", 32);
    public static final Pattern END_GROUP = Pattern.compile("\\\\|$");
    public static final String[] KEYWORDS = new String[]{"assert", "break", "case", "catch", "continue", "default", "do", "else", "finally", "for", "if", "instanceof", "import", "new", "package", "return", "switch", "throw", "try", "typeof", "while", "debugger", "export"};
    public static final String[] RESERVED = new String[]{"const", "goto"};
    public static final String[] CONSTANTS = new String[]{"false", "null", "true"};
    public static final String[] MAGIC_VARIABLES = new String[]{"this", "super"};
    public static final String[] TYPES = new String[]{"boolean", "byte", "char", "class", "double", "enum", "float", "int", "interface", "long", "short", "void", "[]"};
    public static final String[] DIRECTIVES = new String[]{"abstract", "extends", "final", "implements", "native", "private", "protected", "public", "static", "strictfp", "synchronized", "throws", "transient", "volatile"};
    public static final WordList<TokenType> IDENT_KIND = new WordList<TokenType>(TokenType.ident).add(KEYWORDS, TokenType.keyword).add(RESERVED, TokenType.reserved).add(CONSTANTS, TokenType.predefined_constant).add(MAGIC_VARIABLES, TokenType.local_variable).add(TYPES, TokenType.type).add(BuiltInTypes.PREDEFINED_TYPES, TokenType.predefined_type).add(BuiltInTypes.EXCEPTION_TYPES, TokenType.exception).add(DIRECTIVES, TokenType.directive);
    public static final Map<String, Pattern> STRING_CONTENT_PATTERN = new HashMap<String, Pattern>();
    public static final Scanner.Type TYPE = new Scanner.Type("JAVA", "\\.(java)$");

    public JavaScanner() {
        STRING_CONTENT_PATTERN.put("'", STRING_CONTENT_PATTERN_SINGLE);
        STRING_CONTENT_PATTERN.put("\"", STRING_CONTENT_PATTERN_DOUBLE);
        STRING_CONTENT_PATTERN.put("/", STRING_CONTENT_PATTERN_MULTI_LINE);
    }

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        String string_delimiter = null;
        TokenType package_name_expected = null;
        boolean class_name_follows = false;
        boolean last_token_dot = false;
        block4: while (source.hasMore()) {
            MatchResult m = null;
            switch (state) {
                case initial: {
                    m = source.scan(SPACE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.space);
                        continue block4;
                    }
                    m = source.scan(COMMENT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.comment);
                        continue block4;
                    }
                    if (package_name_expected != null && (m = source.scan(PACKAGE)) != null) {
                        encoder.textToken(m.group(), package_name_expected);
                        break;
                    }
                    m = source.scan(IDENT_OR_ARRAY_TYPE);
                    if (m != null) {
                        String match = m.group();
                        TokenType kind = IDENT_KIND.lookup(match);
                        if (last_token_dot) {
                            kind = TokenType.ident;
                        } else if (class_name_follows) {
                            kind = TokenType.class_;
                            class_name_follows = false;
                        } else if ("import".equals(match)) {
                            package_name_expected = TokenType.include;
                        } else if ("package".equals(match)) {
                            package_name_expected = TokenType.namespace;
                        } else if ("class".equals(match) || "interface".equals(match)) {
                            class_name_follows = true;
                        }
                        encoder.textToken(match, kind);
                        break;
                    }
                    m = source.scan(OPERATORS);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    m = source.scan(SEMI_COLON);
                    if (m != null) {
                        package_name_expected = null;
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    m = source.scan(OPEN_BRAKCET);
                    if (m != null) {
                        class_name_follows = false;
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    m = source.check(ANY_WORD);
                    if (m != null) {
                        m = source.scan(HEX);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.hex);
                            break;
                        }
                        m = source.scan(OCTAL);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.octal);
                            break;
                        }
                        m = source.scan(FLOAT);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.float_);
                            break;
                        }
                        m = source.scan(INTEGER);
                        if (m == null) break;
                        encoder.textToken(m.group(), TokenType.integer);
                        break;
                    }
                    m = source.scan(START_STRING);
                    if (m != null) {
                        state = State.string;
                        encoder.beginGroup(TokenType.string);
                        string_delimiter = m.group();
                        encoder.textToken(m.group(), TokenType.delimiter);
                        break;
                    }
                    m = source.scan(ANNOTATION);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.annotation);
                        break;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    break;
                }
                case string: {
                    m = source.scan(STRING_CONTENT_PATTERN.get(string_delimiter));
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(END_STRING);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.delimiter);
                        encoder.endGroup(TokenType.string);
                        state = State.initial;
                        string_delimiter = null;
                        break;
                    }
                    if (state == State.string && (m = source.scan(STRING_CONTENT)) != null) {
                        if ("'".equals(string_delimiter) && !"\\\\".equals(m.group()) && !"\\'".equals(m.group())) {
                            encoder.textToken(m.group(), TokenType.content);
                            break;
                        }
                        encoder.textToken(m.group(), TokenType.char_);
                        break;
                    }
                    m = source.scan(STRING_CONTENT_2);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(END_GROUP);
                    if (m != null) {
                        encoder.endGroup(TokenType.string);
                        state = State.initial;
                        if (m.group().isEmpty()) break;
                        encoder.textToken(m.group(), TokenType.error);
                        break;
                    }
                    throw new RuntimeException("else case \" reached; " + source.peek(1) + " in " + this.getClass());
                }
                default: {
                    throw new RuntimeException("unknown state " + (Object)((Object)state));
                }
            }
            if (m == null) continue;
            last_token_dot = ".".equals(m.group());
        }
        if (state == State.string) {
            encoder.endGroup(TokenType.string);
        }
    }

    public static enum State {
        initial,
        string;

    }
}

