/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Exclusion;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyException;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.resource.FileResource;

public class MavenDependencyAdapter
extends org.apache.maven.model.Dependency
implements Dependency {
    private static final long serialVersionUID = -518791785675970540L;

    public MavenDependencyAdapter(org.apache.maven.model.Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency must not be null.");
        }
        org.apache.maven.model.Dependency clone = dep.clone();
        this.setArtifactId(clone.getArtifactId());
        this.setGroupId(clone.getGroupId());
        this.setClassifier("".equals(clone.getClassifier()) ? null : clone.getClassifier());
        this.setExclusions(clone.getExclusions());
        if (clone.isOptional()) {
            this.setOptional(clone.isOptional());
        }
        this.setScope(clone.getScope());
        this.setType(clone.getType());
        this.setVersion(clone.getVersion());
        this.setSystemPath(clone.getSystemPath());
    }

    public MavenDependencyAdapter(Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency must not be null.");
        }
        this.setArtifactId(dep.getCoordinate().getArtifactId());
        this.setGroupId(dep.getCoordinate().getGroupId());
        this.setVersion(dep.getCoordinate().getVersion());
        this.setScope(dep.getScopeType());
        this.setType(dep.getCoordinate().getPackaging());
        this.setClassifier(dep.getCoordinate().getClassifier());
        this.setSystemPath(dep.getCoordinate().getSystemPath());
        if (dep.isOptional()) {
            this.setOptional(dep.isOptional());
        }
        if (dep.getExcludedCoordinates() != null) {
            for (Coordinate exclusion : dep.getExcludedCoordinates()) {
                Exclusion temp = new Exclusion();
                temp.setArtifactId(exclusion.getArtifactId());
                temp.setGroupId(exclusion.getGroupId());
                this.getExclusions().add(temp);
            }
        }
    }

    public MavenDependencyAdapter(org.eclipse.aether.graph.Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency must not be null.");
        }
        this.setArtifactId(dep.getArtifact().getArtifactId());
        this.setGroupId(dep.getArtifact().getGroupId());
        this.setClassifier("".equals(dep.getArtifact().getClassifier()) ? null : dep.getArtifact().getClassifier());
        this.setExclusions(dep.getExclusions());
        if (dep.isOptional()) {
            this.setOptional(dep.isOptional());
        }
        this.setScope(dep.getScope());
        this.setType(dep.getArtifact().getExtension());
        this.setVersion(dep.getArtifact().getBaseVersion());
    }

    public Coordinate getCoordinate() {
        return CoordinateBuilder.create().setArtifactId(this.getArtifactId()).setClassifier(this.getClassifier()).setGroupId(this.getGroupId()).setPackaging(this.getType()).setSystemPath(this.getSystemPath()).setVersion(this.getVersion());
    }

    public FileResource<?> getArtifact() throws DependencyException {
        return null;
    }

    private void setExclusions(Collection<org.eclipse.aether.graph.Exclusion> exclusions) {
        ArrayList<Exclusion> result = new ArrayList<Exclusion>();
        for (org.eclipse.aether.graph.Exclusion exclusion : exclusions) {
            Exclusion temp = new Exclusion();
            temp.setArtifactId(exclusion.getArtifactId());
            temp.setGroupId(exclusion.getGroupId());
            result.add(temp);
        }
        super.setExclusions(result);
    }

    public String getScope() {
        return super.getScope() == null ? null : super.getScope().toLowerCase().trim();
    }

    public String getScopeType() {
        return this.getScope();
    }

    public List<Coordinate> getExcludedCoordinates() {
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        List exclusions = this.getExclusions();
        for (Exclusion exclusion : exclusions) {
            CoordinateBuilder coord = CoordinateBuilder.create().setArtifactId(exclusion.getArtifactId()).setGroupId(exclusion.getGroupId());
            result.add((Coordinate)coord);
        }
        return result;
    }

    public static List<Dependency> fromMavenList(List<org.apache.maven.model.Dependency> dependencies) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency dep : dependencies) {
            result.add(new MavenDependencyAdapter(dep));
        }
        return result;
    }

    public static List<org.apache.maven.model.Dependency> toMavenList(List<Dependency> dependencies) {
        ArrayList<org.apache.maven.model.Dependency> result = new ArrayList<org.apache.maven.model.Dependency>();
        for (Dependency dep : dependencies) {
            result.add(new MavenDependencyAdapter(dep));
        }
        return result;
    }

    public String getType() {
        return super.getType() == null ? null : super.getType().toLowerCase().trim();
    }

    public String toString() {
        return this.getCoordinate().toString();
    }

    public static List<Dependency> fromAetherList(List<org.eclipse.aether.graph.Dependency> dependencies) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (org.eclipse.aether.graph.Dependency dependency : dependencies) {
            result.add(new MavenDependencyAdapter(dependency));
        }
        return result;
    }
}

