/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.binary;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.procyon.ProcyonConfiguration;
import org.jboss.windup.decompiler.procyon.ProcyonDecompiler;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileModelService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.model.WarArchiveModel;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ProcyonDecompilerOperation
extends AbstractIterationOperation<ArchiveModel> {
    private static final String TECH_TAG = "Decompiled Java File";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public ProcyonDecompilerOperation(String variableName) {
        super(variableName);
    }

    public ProcyonDecompilerOperation() {
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        if (payload.getUnzippedDirectory() != null) {
            ProcyonDecompiler decompiler = new ProcyonDecompiler(new ProcyonConfiguration().setIncludeNested(false));
            String archivePath = payload.getFilePath();
            File archive = new File(archivePath);
            File outputDir = new File(payload.getUnzippedDirectory().getFilePath());
            if (payload instanceof WarArchiveModel) {
                outputDir = outputDir.toPath().resolve("WEB-INF").resolve("classes").toFile();
            }
            try {
                DecompilationResult result = decompiler.decompileArchive(archive, outputDir);
                Map decompiledOutputFiles = result.getDecompiledFiles();
                FileModelService fileService = new FileModelService(event.getGraphContext());
                for (Map.Entry decompiledEntry : decompiledOutputFiles.entrySet()) {
                    String[] classFilePathTokens = ((String)decompiledEntry.getKey()).split("\\\\|/");
                    Path classFilePath = Paths.get(payload.getUnzippedDirectory().getFilePath(), new String[0]);
                    for (String pathToken : classFilePathTokens) {
                        classFilePath = classFilePath.resolve(pathToken);
                    }
                    String decompiledOutputFile = (String)decompiledEntry.getValue();
                    FileModel decompiledFileModel = (FileModel)fileService.getUniqueByProperty("filePath", (Object)decompiledOutputFile);
                    if (decompiledFileModel == null) {
                        FileModel parentFileModel = fileService.findByPath(Paths.get(decompiledOutputFile, new String[0]).getParent().toString());
                        decompiledFileModel = fileService.createByFilePath(parentFileModel, decompiledOutputFile);
                        decompiledFileModel.setParentArchive(payload);
                    }
                    ProjectModel projectModel = payload.getProjectModel();
                    decompiledFileModel.setProjectModel(projectModel);
                    projectModel.addFileModel(decompiledFileModel);
                    if (decompiledOutputFile.endsWith(".java")) {
                        if (!(decompiledFileModel instanceof JavaSourceFileModel)) {
                            decompiledFileModel = (FileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)decompiledFileModel, JavaSourceFileModel.class);
                        }
                        JavaSourceFileModel decompiledSourceFileModel = (JavaSourceFileModel)decompiledFileModel;
                        TechnologyTagService techTagService = new TechnologyTagService(event.getGraphContext());
                        techTagService.addTagToFileModel((FileModel)decompiledSourceFileModel, TECH_TAG, TECH_TAG_LEVEL);
                        FileModel classFileModel = (FileModel)fileService.getUniqueByProperty("filePath", (Object)classFilePath.toAbsolutePath().toString());
                        if (classFileModel != null && classFileModel instanceof JavaClassFileModel) {
                            JavaClassFileModel classModel = (JavaClassFileModel)classFileModel;
                            classModel.getJavaClass().setDecompiledSource(decompiledSourceFileModel);
                            decompiledSourceFileModel.setPackageName(classModel.getPackageName());
                        } else {
                            throw new WindupException("Failed to find original JavaClassFileModel for decompiled Java file: " + decompiledOutputFile + " at: " + classFilePath.toString());
                        }
                    }
                    payload.addDecompiledFileModel(decompiledFileModel);
                }
            }
            catch (DecompilationException exc) {
                throw new WindupException("Error decompiling archive " + archivePath + " due to: " + exc.getMessage(), (Throwable)exc);
            }
        }
    }

    public String toString() {
        return "DecompileWithProcyon";
    }
}

