/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.AeshConsoleCallback;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.extensions.choice.aesh.MultipleChoice;
import org.jboss.aesh.extensions.harlem.console.Harlem;
import org.jboss.aesh.extensions.less.console.Less;
import org.jboss.aesh.extensions.manual.console.Man;
import org.jboss.aesh.extensions.more.console.More;
import org.jboss.aesh.parser.Parser;

public class ExampleExtension {
    public static void main(String[] args) throws IOException {
        SettingsBuilder settingsBuilder = new SettingsBuilder();
        settingsBuilder.readInputrc(false);
        settingsBuilder.logging(true);
        final Console exampleConsole = new Console(settingsBuilder.create());
        PrintWriter out = new PrintWriter(System.out);
        final Man man = new Man(exampleConsole);
        final Harlem harlem = new Harlem(exampleConsole);
        final Less less = new Less(exampleConsole);
        final More more = new More(exampleConsole);
        ArrayList<org.jboss.aesh.extensions.choice.console.MultipleChoice> choices = new ArrayList<org.jboss.aesh.extensions.choice.console.MultipleChoice>();
        choices.add(new org.jboss.aesh.extensions.choice.console.MultipleChoice(1, "Do you want foo?"));
        choices.add(new org.jboss.aesh.extensions.choice.console.MultipleChoice(2, "Do you want bar?"));
        MultipleChoice choice = new MultipleChoice(exampleConsole, "choice", choices);
        Completion completer = new Completion(){

            public void complete(CompleteOperation co) {
                ArrayList<String> commands = new ArrayList<String>();
                if (co.getBuffer().equals("fo") || co.getBuffer().equals("foo")) {
                    commands.add("foo");
                    commands.add("foobaa");
                    commands.add("foobar");
                    commands.add("foobaxxxxxx");
                    commands.add("foobbx");
                    commands.add("foobcx");
                    commands.add("foobdx");
                } else if (co.getBuffer().equals("fooba")) {
                    commands.add("foobaa");
                    commands.add("foobar");
                    commands.add("foobaxxxxxx");
                } else if (co.getBuffer().equals("foobar")) {
                    commands.add("foobar");
                } else if (co.getBuffer().equals("bar")) {
                    commands.add("bar/");
                } else if (co.getBuffer().equals("h")) {
                    commands.add("help.history");
                    commands.add("help");
                } else if (co.getBuffer().equals("help")) {
                    commands.add("help.history");
                    commands.add("help");
                } else if (co.getBuffer().equals("help.")) {
                    commands.add("help.history");
                } else if (co.getBuffer().equals("deploy")) {
                    commands.add("deploy /home/blabla/foo/bar/alkdfe/en/to/tre");
                }
                co.setCompletionCandidates(commands);
            }
        };
        exampleConsole.addCompletion(completer);
        exampleConsole.addCompletion((Completion)man);
        exampleConsole.addCompletion((Completion)less);
        exampleConsole.addCompletion((Completion)more);
        exampleConsole.addCompletion((Completion)harlem);
        exampleConsole.setPrompt(new Prompt("[test@foo]~> "));
        exampleConsole.setConsoleCallback((ConsoleCallback)new AeshConsoleCallback(){

            public int execute(ConsoleOperation consoleOutput) {
                try {
                    File f;
                    String fileContent;
                    Scanner s;
                    String line = consoleOutput.getBuffer();
                    exampleConsole.getShell().out().print("======>\"" + line + "\"\n");
                    if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit") || line.equalsIgnoreCase("reset")) {
                        exampleConsole.stop();
                    }
                    if (line.equals("clear")) {
                        exampleConsole.clear();
                    }
                    if (line.startsWith("man")) {
                        try {
                            man.setFile("/tmp/test.txt.gz");
                            man.setConsole(exampleConsole);
                            man.setControlOperator(consoleOutput.getControlOperator());
                        }
                        catch (IllegalArgumentException iae) {
                            exampleConsole.getShell().out().print(iae.getMessage());
                        }
                    }
                    if (line.startsWith("choice")) {
                        // empty if block
                    }
                    if (line.startsWith("harlem")) {
                        harlem.afterAttach();
                    }
                    if (line.trim().startsWith("less")) {
                        if (exampleConsole.getShell().in().getStdIn().available() > 0) {
                            s = new Scanner(exampleConsole.getShell().in().getStdIn()).useDelimiter("\\A");
                            fileContent = s.hasNext() ? s.next() : "";
                            less.setInput(fileContent);
                            less.setControlOperator(consoleOutput.getControlOperator());
                            less.afterAttach();
                        } else if (line.length() > "less".length()) {
                            f = new File(Parser.switchEscapedSpacesToSpacesInWord((String)line.substring("less ".length())).trim());
                            if (f.isFile()) {
                                less.setFile(f);
                                less.setControlOperator(consoleOutput.getControlOperator());
                                less.afterAttach();
                            } else if (f.isDirectory()) {
                                exampleConsole.getShell().out().print(f.getAbsolutePath() + ": is a directory" + Config.getLineSeparator());
                            } else {
                                exampleConsole.getShell().out().print(f.getAbsolutePath() + ": No such file or directory" + Config.getLineSeparator());
                            }
                        } else {
                            exampleConsole.getShell().out().print("Missing filename (\"less --help\" for help)\n");
                        }
                    }
                    if (line.startsWith("more")) {
                        if (exampleConsole.getShell().in().getStdIn().available() > 0) {
                            s = new Scanner(exampleConsole.getShell().in().getStdIn()).useDelimiter("\\A");
                            fileContent = s.hasNext() ? s.next() : "";
                            more.setInput(fileContent);
                            more.setControlOperator(consoleOutput.getControlOperator());
                            more.afterAttach();
                        } else {
                            f = new File(Parser.switchEscapedSpacesToSpacesInWord((String)line.substring("more ".length())).trim());
                            if (f.isFile()) {
                                more.setFile(f);
                                more.setControlOperator(consoleOutput.getControlOperator());
                                more.afterAttach();
                            } else if (f.isDirectory()) {
                                exampleConsole.getShell().out().print(f.getAbsolutePath() + ": is a directory" + Config.getLineSeparator());
                            } else {
                                exampleConsole.getShell().out().print(f.getAbsolutePath() + ": No such file or directory" + Config.getLineSeparator());
                            }
                        }
                    }
                    return 0;
                }
                catch (IOException ioe) {
                    return -1;
                }
            }
        });
        exampleConsole.start();
    }
}

