/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.maven.projects.MavenBuildSystem;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenFacetImpl;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.maven.projects.MavenProject;
import org.jboss.forge.addon.maven.projects.facets.MavenDependencyFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenMetadataFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenPackagingFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenWebResourcesFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProvidedProjectFacet;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.Resource;

public class MavenBuildSystemImpl
implements MavenBuildSystem {
    private static final Logger log = Logger.getLogger(MavenBuildSystemImpl.class.getName());
    @Inject
    private FacetFactory factory;

    public String getType() {
        return "Maven";
    }

    public Project createProject(Resource<?> target) {
        MavenProject project = new MavenProject(target);
        try {
            this.factory.install((Faceted)project, MavenFacetImpl.class);
            this.factory.install((Faceted)project, MavenPluginFacet.class);
            this.factory.install((Faceted)project, MavenMetadataFacet.class);
            this.factory.install((Faceted)project, MavenPackagingFacet.class);
            this.factory.install((Faceted)project, MavenDependencyFacet.class);
            try {
                this.factory.register((Faceted)project, MavenWebResourcesFacet.class);
            }
            catch (IllegalStateException e) {
                log.log(Level.FINE, "Could not install [" + MavenWebResourcesFacet.class.getName() + "] into project [" + (Object)((Object)project) + "]", e);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Could not install Maven into Project located at [" + target.getFullyQualifiedName() + "]", e);
        }
        return project;
    }

    public boolean containsProject(Resource<?> target) {
        if (target.exists()) {
            Resource pom = target.getChild("pom.xml");
            return pom != null && pom.exists();
        }
        return false;
    }

    public Set<Class<? extends ProvidedProjectFacet>> getProvidedFacetTypes() {
        HashSet<Class<PackagingFacet>> result = new HashSet<Class<PackagingFacet>>();
        result.add(MavenFacet.class);
        result.add(MavenPluginFacet.class);
        result.add(DependencyFacet.class);
        result.add(MetadataFacet.class);
        result.add(PackagingFacet.class);
        return Collections.unmodifiableSet(result);
    }

    public int priority() {
        return 0;
    }
}

