/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.PrintStream;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalTextStyle;
import org.jboss.aesh.util.ANSI;

public class TerminalString {
    private String characters;
    private TerminalTextStyle style;
    private TerminalColor color;
    private boolean ignoreRendering;
    private int ansiLength = 0;

    public TerminalString(String chars, TerminalColor color, TerminalTextStyle style) {
        this.characters = chars;
        this.color = color;
        this.style = style;
    }

    public TerminalString(String chars, TerminalColor color) {
        this(chars, color, new TerminalTextStyle());
    }

    public TerminalString(String chars, TerminalTextStyle style) {
        this(chars, new TerminalColor(), style);
    }

    public TerminalString(String chars) {
        this(chars, new TerminalColor(), new TerminalTextStyle());
    }

    public TerminalString(String chars, boolean ignoreRendering) {
        this(chars, new TerminalColor(), new TerminalTextStyle());
        this.ignoreRendering = ignoreRendering;
    }

    public String getCharacters() {
        return this.characters;
    }

    public void setCharacters(String chars) {
        this.characters = chars;
    }

    public boolean containSpaces() {
        return this.characters.indexOf(32) > 0;
    }

    public void switchSpacesToEscapedSpaces() {
        this.characters = Parser.switchSpacesToEscapedSpacesInWord(this.characters);
    }

    public TerminalTextStyle getStyle() {
        return this.style;
    }

    public int getANSILength() {
        if (this.ignoreRendering) {
            return 0;
        }
        if (this.ansiLength == 0) {
            this.ansiLength = ANSI.getStart().length() + this.color.getLength() + this.style.getLength() + ANSI.reset().length() + 2;
        }
        return this.ansiLength;
    }

    public TerminalString cloneRenderingAttributes(String chars) {
        if (this.ignoreRendering) {
            return new TerminalString(chars, true);
        }
        return new TerminalString(chars, this.color, this.style);
    }

    public String toString(TerminalString prev) {
        if (this.ignoreRendering) {
            return this.characters;
        }
        if (this.equalsIgnoreCharacter(prev)) {
            return this.characters;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI.getStart()).append(this.style.getValueComparedToPrev(prev.getStyle()));
        if (!this.color.equals(prev.color)) {
            if (prev.getStyle().isInvert()) {
                builder.append(';').append(this.color.toString());
            } else {
                builder.append(';').append(this.color.toString(prev.color));
            }
        }
        builder.append('m').append(this.getCharacters());
        return builder.toString();
    }

    public String toString() {
        if (this.ignoreRendering) {
            return this.characters;
        }
        return ANSI.getStart() + this.style.toString() + ';' + this.color.toString() + 'm' + this.getCharacters() + ANSI.reset();
    }

    public void write(PrintStream out) {
        if (this.ignoreRendering) {
            out.print(this.characters);
        } else {
            out.print(ANSI.getStart());
            out.print(this.style.toString());
            out.print(';');
            this.color.write(out);
            out.print('m');
            out.print(this.getCharacters());
        }
    }

    public boolean equalsIgnoreCharacter(TerminalString that) {
        if (this.style != that.style) {
            return false;
        }
        if (this.ignoreRendering != that.ignoreRendering) {
            return false;
        }
        return this.color.equals(that.color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalString)) {
            return false;
        }
        TerminalString that = (TerminalString)o;
        if (this.ignoreRendering) {
            return this.characters.equals(that.characters);
        }
        if (!this.characters.equals(that.characters)) {
            return false;
        }
        if (!this.color.equals(that.color)) {
            return false;
        }
        return this.style == that.style;
    }

    public int hashCode() {
        int result = this.characters.hashCode();
        result = 31 * result + this.color.hashCode();
        result = 31 * result + this.style.hashCode();
        return result;
    }
}

