/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RexProClientConnection;
import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class RemoteRexsterSession {
    private static final Logger logger = Logger.getLogger(RemoteRexsterSession.class);
    private int rexProPort = 8184;
    private int timeout;
    private String rexProHost = "localhost";
    private String username = "";
    private String password = "";
    private RexProClientConnection rexProConnection;
    private UUID sessionKey = RexProMessage.EMPTY_SESSION;
    private List<String> availableLanguages;

    public RemoteRexsterSession(String rexProHost, int rexProPort, String username, String password) {
        this(rexProHost, rexProPort, 100, username, password);
    }

    public RemoteRexsterSession(String rexProHost, int rexProPort, int timeout, String username, String password) {
        this.rexProHost = rexProHost;
        this.rexProPort = rexProPort;
        this.timeout = timeout;
        this.username = username;
        this.password = password;
        this.rexProConnection = new RexProClientConnection(rexProHost, rexProPort);
    }

    public void open() {
        if (this.sessionKey == RexProMessage.EMPTY_SESSION) {
            RexProMessage rcvMessage;
            SessionRequestMessage sessionRequestMessageToSend = new SessionRequestMessage();
            sessionRequestMessageToSend.Username = this.username;
            sessionRequestMessageToSend.Password = this.password;
            sessionRequestMessageToSend.setSessionAsUUID(SessionRequestMessage.EMPTY_SESSION);
            sessionRequestMessageToSend.setRequestAsUUID(UUID.randomUUID());
            try {
                sessionRequestMessageToSend.validateMetaData();
            }
            catch (RexProException e) {
                e.printStackTrace();
            }
            if (this.rexProConnection == null) {
                this.rexProConnection = new RexProClientConnection(this.rexProHost, this.rexProPort);
            }
            if ((rcvMessage = this.sendRequest(sessionRequestMessageToSend, 3)) != null && rcvMessage instanceof SessionResponseMessage) {
                SessionResponseMessage sessionResponseMessage = (SessionResponseMessage)rcvMessage;
                this.availableLanguages = new ArrayList<String>();
                for (String lang : sessionResponseMessage.Languages) {
                    this.availableLanguages.add(lang);
                }
                this.sessionKey = rcvMessage.sessionAsUUID();
            }
        }
    }

    public boolean isOpen() {
        return this.sessionKey != RexProMessage.EMPTY_SESSION;
    }

    public Iterator<String> getAvailableLanguages() {
        if (this.sessionKey == RexProMessage.EMPTY_SESSION) {
            return null;
        }
        return this.availableLanguages.iterator();
    }

    public boolean isAvailableLanguage(String language) {
        if (this.sessionKey == RexProMessage.EMPTY_SESSION) {
            return false;
        }
        boolean found = false;
        Iterator<String> languageIterator = this.availableLanguages.iterator();
        while (languageIterator.hasNext()) {
            if (!languageIterator.next().equals(language)) continue;
            found = true;
        }
        return found;
    }

    public RexProMessage sendRequest(RexProMessage request, int maxRetries) {
        return this.sendRequest(request, maxRetries, 3000);
    }

    public RexProMessage sendRequest(RexProMessage request, int maxRetries, int waitMsBetweenTries) {
        int tries = 0;
        RexProMessage rcvMessage = null;
        request.setSessionAsUUID(this.getSessionKey());
        while (rcvMessage == null && tries < maxRetries) {
            ++tries;
            try {
                rcvMessage = this.rexProConnection.sendMessage(request);
            }
            catch (Exception ex) {
                String logMessage = "Failure sending message via RexPro. Attempt [" + tries + "] of [" + maxRetries + "].";
                if (tries < maxRetries) {
                    logMessage = logMessage + " Trying again in " + waitMsBetweenTries + " (ms)";
                }
                logger.error((Object)logMessage);
                rcvMessage = null;
                try {
                    Thread.sleep(waitMsBetweenTries);
                }
                catch (InterruptedException ie) {}
            }
        }
        return rcvMessage;
    }

    public void reset() {
        this.close();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.sessionKey != RexProMessage.EMPTY_SESSION) {
                SessionRequestMessage sessionKillMessageToSend = new SessionRequestMessage();
                sessionKillMessageToSend.metaSetKillSession(true);
                sessionKillMessageToSend.setRequestAsUUID(UUID.randomUUID());
                sessionKillMessageToSend.setSessionAsUUID(this.sessionKey);
                RexProMessage rcvMessage = this.sendRequest(sessionKillMessageToSend, 3);
                if (rcvMessage instanceof SessionResponseMessage) {
                    this.sessionKey = rcvMessage.sessionAsUUID();
                }
                this.rexProConnection.close();
                this.rexProConnection = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.sessionKey = RexProMessage.EMPTY_SESSION;
        }
    }

    UUID getSessionKey() {
        return this.sessionKey;
    }

    public String getRexProHost() {
        return this.rexProHost;
    }

    public int getRexProPort() {
        return this.rexProPort;
    }
}

