/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.client.RexsterClient;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.MessageUtil;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import com.tinkerpop.rexster.protocol.serializer.RexProSerializer;
import com.tinkerpop.rexster.protocol.serializer.json.JSONSerializer;
import com.tinkerpop.rexster.protocol.serializer.msgpack.MsgPackSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

public class RexProClientFilter
extends BaseFilter {
    private static final Logger logger = Logger.getLogger(RexProClientFilter.class);
    private static MsgPackSerializer msgPackSerializer = new MsgPackSerializer();
    private static JSONSerializer jsonSerializer = new JSONSerializer();
    private static int ENVELOPE_LENGTH = 11;

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer sourceBuffer = (Buffer)ctx.getMessage();
        int sourceBufferLength = sourceBuffer.remaining();
        if (sourceBufferLength < ENVELOPE_LENGTH) {
            return ctx.getStopAction((Object)sourceBuffer);
        }
        byte messageVersion = sourceBuffer.get(0);
        byte serializerType = sourceBuffer.get(1);
        byte messageType = sourceBuffer.get(6);
        int bodyLength = sourceBuffer.getInt(7);
        int completeMessageLength = ENVELOPE_LENGTH + bodyLength;
        if (messageVersion != 1) {
            logger.warn((Object)("unsupported rexpro version: " + messageVersion));
            return ctx.getStopAction();
        }
        if (sourceBufferLength < completeMessageLength) {
            logger.warn((Object)String.format("Message envelope is incomplete. Message length set to %s but the buffer only contains %s", completeMessageLength, sourceBufferLength));
            return ctx.getStopAction((Object)sourceBuffer);
        }
        if (completeMessageLength < 0) {
            logger.warn((Object)String.format("Message body length in the envelope is negative: %s.", completeMessageLength));
            return ctx.getStopAction((Object)sourceBuffer);
        }
        Buffer remainder = sourceBufferLength > completeMessageLength ? sourceBuffer.split(completeMessageLength) : null;
        byte[] messageAsBytes = new byte[bodyLength];
        sourceBuffer.position(ENVELOPE_LENGTH);
        sourceBuffer.get(messageAsBytes);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (byte b : messageAsBytes) {
                sb.append(StringUtils.rightPad((String)Byte.toString(b), (int)4));
                sb.append(" ");
            }
            logger.debug((Object)String.format("Received message [version:%s][message type:%s][body length:%s][body:%s]", messageVersion, messageType, bodyLength, sb.toString().trim()));
        }
        try {
            RexProSerializer serializer;
            if (serializerType == msgPackSerializer.getSerializerId()) {
                serializer = msgPackSerializer;
            } else if (serializerType == jsonSerializer.getSerializerId()) {
                serializer = jsonSerializer;
            } else {
                throw new RexProException(String.format("unknown serializer type: %s", serializerType));
            }
            RexProMessage message = null;
            if (messageType == 3) {
                message = serializer.deserialize(messageAsBytes, ScriptRequestMessage.class);
            } else if (messageType == 1) {
                message = serializer.deserialize(messageAsBytes, SessionRequestMessage.class);
            } else if (messageType == 2) {
                message = serializer.deserialize(messageAsBytes, SessionResponseMessage.class);
            } else if (messageType == 0) {
                message = serializer.deserialize(messageAsBytes, ErrorResponseMessage.class);
            } else if (messageType == 5) {
                message = serializer.deserialize(messageAsBytes, ScriptResponseMessage.class);
            }
            if (message == null) {
                logger.warn((Object)String.format("Message did not match the specified type [%s]", messageType));
                ctx.write((Object)MessageUtil.createErrorResponse(RexProMessage.EMPTY_REQUEST_AS_BYTES, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_MESSAGE_ERROR, "Message did not match an expected type."));
                return ctx.getStopAction();
            }
            ctx.setMessage((Object)message);
            sourceBuffer.tryDispose();
            return ctx.getInvokeAction((Object)remainder);
        }
        catch (Exception ex) {
            logger.error((Object)String.format("Error during message deserialization of a message of type [%s].", messageType), (Throwable)ex);
            ErrorResponseMessage deserializationMessage = MessageUtil.createErrorResponse(RexProMessage.EMPTY_REQUEST_AS_BYTES, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_MESSAGE_ERROR, ex.toString());
            try {
                ctx.write((Object)deserializationMessage);
            }
            catch (Exception inner) {
                logger.error((Object)String.format("Could not write error message back to client for request [%s] session [%s].  Should have reported flag [%s] message [%s] to client", deserializationMessage.requestAsUUID(), deserializationMessage.sessionAsUUID(), deserializationMessage.metaGetFlag(), deserializationMessage.ErrorMessage));
            }
            return ctx.getStopAction();
        }
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object rawMsg = ctx.getMessage();
        RexsterClient.MessageContainer container = (RexsterClient.MessageContainer)rawMsg;
        byte serializerType = container.getSerializer();
        RexProMessage msg = container.getMessage();
        byte[] rexProMessageAsBytes = new byte[]{};
        try {
            RexProSerializer serializer;
            if (serializerType == msgPackSerializer.getSerializerId()) {
                serializer = msgPackSerializer;
            } else if (serializerType == jsonSerializer.getSerializerId()) {
                serializer = jsonSerializer;
            } else {
                throw new RexProException(String.format("unknown serializer type: %s", serializerType));
            }
            if (msg instanceof SessionResponseMessage) {
                rexProMessageAsBytes = serializer.serialize((SessionResponseMessage)msg, SessionResponseMessage.class);
            } else if (msg instanceof ErrorResponseMessage) {
                rexProMessageAsBytes = serializer.serialize((ErrorResponseMessage)msg, ErrorResponseMessage.class);
            } else if (msg instanceof ScriptRequestMessage) {
                rexProMessageAsBytes = serializer.serialize((ScriptRequestMessage)msg, ScriptRequestMessage.class);
            } else if (msg instanceof SessionRequestMessage) {
                rexProMessageAsBytes = serializer.serialize((SessionRequestMessage)msg, SessionRequestMessage.class);
            } else if (msg instanceof ScriptResponseMessage) {
                rexProMessageAsBytes = serializer.serialize((ScriptResponseMessage)msg, ScriptResponseMessage.class);
            }
        }
        catch (Exception ex) {
            ByteArrayOutputStream rpms = new ByteArrayOutputStream();
            ErrorResponseMessage errorMsg = MessageUtil.createErrorResponse(msg.Request, msg.Session, ErrorResponseMessage.RESULT_SERIALIZATION_ERROR, "Script was successfully executed but the result of the script was not properly serialized.");
            rexProMessageAsBytes = rpms.toByteArray();
            ctx.setMessage(null);
            return ctx.getStopAction();
        }
        MemoryManager memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        Buffer bb = memoryManager.allocate(ENVELOPE_LENGTH + rexProMessageAsBytes.length);
        bb.put((byte)1);
        bb.put(serializerType);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        if (msg instanceof SessionResponseMessage) {
            bb.put((byte)2);
        } else if (msg instanceof ErrorResponseMessage) {
            bb.put((byte)0);
        } else if (msg instanceof ScriptRequestMessage) {
            bb.put((byte)3);
        } else if (msg instanceof SessionRequestMessage) {
            bb.put((byte)1);
        } else if (msg instanceof ScriptResponseMessage) {
            bb.put((byte)5);
        }
        bb.putInt(rexProMessageAsBytes.length);
        bb.put(rexProMessageAsBytes);
        bb.allowBufferDispose(true);
        ctx.setMessage((Object)bb.flip());
        return ctx.getInvokeAction();
    }
}

