/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.gremlin.converter;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SerializedResultConverter {
    static Object serializeElementId(Element element) {
        Object id = element.getId();
        if (id.getClass().isPrimitive()) {
            return id;
        }
        return id.toString();
    }

    public static Object convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String || object instanceof Number || object instanceof Boolean) {
            return object;
        }
        if (object instanceof Element) {
            try {
                Element element = (Element)object;
                Set propertyKeys = element.getPropertyKeys();
                boolean isVertex = !(element instanceof Edge);
                HashMap<String, Object> outMap = new HashMap<String, Object>();
                outMap.put("_id", SerializedResultConverter.serializeElementId(element));
                if (isVertex) {
                    outMap.put("_type", "vertex");
                } else {
                    Edge edge = (Edge)element;
                    outMap.put("_type", "edge");
                    outMap.put("_inV", SerializedResultConverter.serializeElementId((Element)edge.getVertex(Direction.IN)));
                    outMap.put("_outV", SerializedResultConverter.serializeElementId((Element)edge.getVertex(Direction.OUT)));
                    outMap.put("_label", edge.getLabel());
                }
                if (propertyKeys.size() > 0) {
                    HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                    for (String propertyKey : propertyKeys) {
                        propertyMap.put(propertyKey, SerializedResultConverter.convert(element.getProperty(propertyKey)));
                    }
                    outMap.put("_properties", propertyMap);
                }
                return outMap;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<String, Object> outMap = new HashMap<String, Object>();
            for (Object key : map.keySet()) {
                if (key instanceof Element) {
                    Element element = (Element)key;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("_key", element);
                    m.put("_value", map.get(key));
                    outMap.put(element.getId().toString(), SerializedResultConverter.convert(m));
                    continue;
                }
                outMap.put((String)key, SerializedResultConverter.convert(map.get(key)));
            }
            return outMap;
        }
        if (object instanceof Table) {
            Table table = (Table)object;
            Iterator rows = table.iterator();
            ArrayList<Object> outArray = new ArrayList<Object>();
            while (rows.hasNext()) {
                outArray.add(SerializedResultConverter.convert(rows.next()));
            }
            return outArray;
        }
        if (object instanceof Row) {
            Row row = (Row)object;
            List columnNames = row.getColumnNames();
            HashMap<String, Object> outMap = new HashMap<String, Object>();
            for (String columnName : columnNames) {
                outMap.put(columnName, SerializedResultConverter.convert(row.getColumn(columnName)));
            }
            return outMap;
        }
        if (object instanceof Iterable) {
            ArrayList<Object> outArray = new ArrayList<Object>();
            for (Object o : (Iterable)object) {
                outArray.add(SerializedResultConverter.convert(o));
            }
            return outArray;
        }
        if (object instanceof Iterator) {
            ArrayList<Object> outArray = new ArrayList<Object>();
            Iterator itty = (Iterator)object;
            while (itty.hasNext()) {
                outArray.add(SerializedResultConverter.convert(itty.next()));
            }
            return outArray;
        }
        return object.toString();
    }
}

