/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.json.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

public class JsonConverter {
    public static JsonNode toJsonNode(Object obj) {
        if (obj == null) {
            return NullNode.getInstance();
        }
        if (obj instanceof Map) {
            ObjectNode map = new ObjectNode(JsonNodeFactory.instance);
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                map.put(entry.getKey().toString(), JsonConverter.toJsonNode(entry.getValue()));
            }
            return map;
        }
        if (obj instanceof Iterable) {
            ArrayNode array = new ArrayNode(JsonNodeFactory.instance);
            for (Object o : (Iterable)obj) {
                array.add(JsonConverter.toJsonNode(o));
            }
            return array;
        }
        if (obj instanceof Object[]) {
            ArrayNode array = new ArrayNode(JsonNodeFactory.instance);
            for (Object o : (Object[])obj) {
                array.add(JsonConverter.toJsonNode(o));
            }
            return array;
        }
        if (obj instanceof Integer) {
            return new IntNode(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new LongNode(((Long)obj).longValue());
        }
        if (obj instanceof Double) {
            return new DoubleNode(((Double)obj).doubleValue());
        }
        if (obj instanceof Float) {
            return new DoubleNode((double)((Float)obj).floatValue());
        }
        if (obj instanceof Boolean) {
            return BooleanNode.valueOf((boolean)((Boolean)obj));
        }
        return new TextNode(obj.toString());
    }

    public static Object fromJsonNode(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ObjectNode objectNode = (ObjectNode)node;
            Iterator iterator = objectNode.getFieldNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, JsonConverter.fromJsonNode(objectNode.get(key)));
            }
            return map;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> array = new ArrayList<Object>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                array.add(JsonConverter.fromJsonNode(arrayNode.get(i)));
            }
            return array;
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isIntegralNumber()) {
            return node.asLong();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.asText();
    }
}

