/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.session;

import com.tinkerpop.rexster.protocol.session.RexProSession;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class RexProSessions {
    private static final Logger logger = Logger.getLogger(RexProSessions.class);
    protected static final ConcurrentHashMap<String, RexProSession> sessions = new ConcurrentHashMap();

    public static RexProSession getSession(String sessionKey) {
        return sessions.get(sessionKey);
    }

    public static void destroySession(String sessionKey) {
        logger.info((Object)String.format("Try to destroy RexPro Session: %s", sessionKey));
        RexProSession session = RexProSessions.getSession(sessionKey);
        if (session != null) {
            session.kill();
            sessions.remove(sessionKey);
        }
        logger.info((Object)String.format("RexPro Session destroyed or doesn't otherwise exist: %s", sessionKey));
    }

    public static void destroyAllSessions() {
        for (String keyToRemove : sessions.keySet()) {
            RexProSessions.destroySession(keyToRemove);
        }
    }

    public static boolean hasSessionKey(String sessionKey) {
        return sessions.containsKey(sessionKey);
    }

    public static Collection<String> getSessionKeys() {
        return sessions.keySet();
    }

    public static void ensureSessionExists(String sessionKey, RexsterApplication rexsterApplication) {
        if (!sessions.containsKey(sessionKey)) {
            RexProSession session = new RexProSession(sessionKey, rexsterApplication);
            sessions.put(sessionKey, session);
            logger.info((Object)String.format("RexPro Session created: %s", sessionKey));
        }
    }

    public static RexProSession createSession(String sessionKey, RexsterApplication rexsterApplication) {
        RexProSession session = new RexProSession(sessionKey, rexsterApplication);
        sessions.put(sessionKey, session);
        logger.info((Object)String.format("RexPro Session created: %s", sessionKey));
        return session;
    }
}

