/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.jboss.windup.util.ExecutionStatistics;

public class ProjectModelToApplicationIndexMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "projectModelToApplicationIndex";
    private ApplicationReportIndexService service;

    public void setContext(GraphRewrite event) {
        this.service = new ApplicationReportIndexService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (ProjectModel)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        ProjectModel projectModel = (ProjectModel)stringModelArg.getWrappedObject();
        ApplicationReportIndexModel index = this.service.getApplicationReportIndexForProjectModel(projectModel);
        ExecutionStatistics.get().end(NAME);
        return index;
    }
}

