/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import com.tinkerpop.rexster.AbstractSubResource;
import com.tinkerpop.rexster.EdgeResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.util.ElementHelper;
import com.tinkerpop.rexster.util.RequestObjectHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs/{graphname}/indices")
public class IndexResource
extends AbstractSubResource {
    private static final Logger logger = Logger.getLogger(EdgeResource.class);

    public IndexResource() {
        super(null);
    }

    public IndexResource(UriInfo ui, HttpServletRequest req, RexsterApplication ra) {
        super(ra);
        this.httpServletRequest = req;
        this.uriInfo = ui;
    }

    @OPTIONS
    public Response optionsAllIndices() {
        return this.buildOptionsResponse(HttpMethod.GET.toString());
    }

    @GET
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.collection.get", absolute=true)
    public Response getAllIndices(@PathParam(value="graphname") String graphName) {
        IndexableGraph idxGraph;
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        JSONObject theRequestObject = this.getRequestObject();
        IndexableGraph indexableGraph = idxGraph = graph instanceof IndexableGraph ? (IndexableGraph)graph : null;
        if (idxGraph == null) {
            JSONObject error = this.generateErrorObject("The requested graph is not of type " + IndexableGraph.class.getName() + ".");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        Long start = RequestObjectHelper.getStartOffset((JSONObject)theRequestObject);
        Long end = RequestObjectHelper.getEndOffset((JSONObject)theRequestObject);
        long counter = 0L;
        try {
            JSONArray indexArray = new JSONArray();
            for (Index index : idxGraph.getIndices()) {
                if (counter >= start && counter < end) {
                    indexArray.put((Object)IndexResource.createJSONObject(index));
                }
                ++counter;
            }
            this.resultObject.put("results", (Object)indexArray);
            this.resultObject.put("totalSize", counter);
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @OPTIONS
    @Path(value="/{indexName}")
    public Response optionsElementsFromIndex() {
        return this.buildOptionsResponse(HttpMethod.GET.toString(), HttpMethod.DELETE.toString(), HttpMethod.POST.toString(), HttpMethod.PUT.toString());
    }

    @GET
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.indices.object.get", absolute=true)
    public Response getElementsFromIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName) {
        return this.getElementsFromIndex(graphName, indexName, false);
    }

    @GET
    @Path(value="/{indexName}")
    @Produces(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.get", absolute=true)
    public Response getElementsFromIndexRexsterTypedJson(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName) {
        return this.getElementsFromIndex(graphName, indexName, true);
    }

    private Response getElementsFromIndex(String graphName, String indexName, boolean showTypes) {
        Index index = this.getIndexFromGraph(graphName, indexName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        String key = null;
        Object value = null;
        JSONObject theRequestObject = this.getRequestObject();
        Object temp = theRequestObject.opt("key");
        if (null != temp) {
            key = temp.toString();
        }
        if (null != (temp = theRequestObject.opt("value"))) {
            value = ElementHelper.getTypedPropertyValue((Object)temp.toString());
        }
        Long start = RequestObjectHelper.getStartOffset((JSONObject)theRequestObject);
        Long end = RequestObjectHelper.getEndOffset((JSONObject)theRequestObject);
        Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
        GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
        long counter = 0L;
        if (null != index && key != null && value != null) {
            CloseableIterable indexElements = index.get(key, value);
            try {
                JSONArray elementArray = new JSONArray();
                for (Element element : indexElements) {
                    if (counter >= start && counter < end) {
                        elementArray.put((Object)GraphSONUtility.jsonFromElement((Element)element, (Set)returnKeys, (GraphSONMode)mode));
                    }
                    ++counter;
                }
                this.resultObject.put("results", (Object)elementArray);
                this.resultObject.put("totalSize", counter);
                this.resultObject.put("queryTime", this.sh.stopWatch());
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
            finally {
                indexElements.close();
                rag.tryCommit();
            }
        } else {
            if (null == index) {
                String msg = "Could not find index [" + indexName + "] on graph [" + graphName + "]";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("queryTime", this.sh.stopWatch());
            map.put("results", (Double)IndexResource.createJSONObject(index));
            this.resultObject = new JSONObject(map);
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @OPTIONS
    @Path(value="/{indexName}/count")
    @Timed(name="http.rest.indices.count.get", absolute=true)
    public Response optionsIndexCount() {
        return this.buildOptionsResponse(HttpMethod.GET.toString());
    }

    @GET
    @Path(value="/{indexName}/count")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.count.get", absolute=true)
    public Response getIndexCount(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName) {
        Index index = this.getIndexFromGraph(graphName, indexName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        String key = null;
        Object value = null;
        JSONObject theRequestObject = this.getRequestObject();
        Object temp = theRequestObject.opt("key");
        if (temp != null) {
            key = temp.toString();
        }
        if ((temp = theRequestObject.opt("value")) != null) {
            value = ElementHelper.getTypedPropertyValue((Object)temp.toString());
        }
        if (index != null && key != null && value != null) {
            try {
                long count = index.count(key, value);
                this.resultObject.put("totalSize", count);
                this.resultObject.put("queryTime", this.sh.stopWatch());
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
            finally {
                rag.tryCommit();
            }
        } else {
            if (null == index) {
                String msg = "Could not find index [" + indexName + "] on graph [" + graphName + "]";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            String msg = "A key and value must be provided to lookup elements in an index";
            logger.info((Object)"A key and value must be provided to lookup elements in an index");
            JSONObject error = this.generateErrorObject("A key and value must be provided to lookup elements in an index");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @DELETE
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.delete", absolute=true)
    public Response deleteIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName, JSONObject json) {
        this.setRequestObject(json);
        return this.deleteIndex(graphName, indexName);
    }

    @DELETE
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.delete", absolute=true)
    public Response deleteIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName) {
        String key = null;
        Object value = null;
        String id = null;
        JSONObject theRequestObject = this.getRequestObject();
        Object temp = theRequestObject.opt("key");
        if (null != temp) {
            key = temp.toString();
        }
        if (null != (temp = theRequestObject.opt("value"))) {
            value = ElementHelper.getTypedPropertyValue((Object)temp.toString());
        }
        if (null != (temp = theRequestObject.opt("id"))) {
            id = temp.toString();
        }
        Index index = this.getIndexFromGraph(graphName, indexName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        IndexableGraph graph = (IndexableGraph)rag.getGraph();
        if (null == index) {
            String msg = "Could not find index [" + indexName + "] on graph [" + graphName + "]";
            logger.info((Object)msg);
            JSONObject error = this.generateErrorObject(msg);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
        }
        if (key == null && value == null && id == null) {
            try {
                graph.dropIndex(indexName);
                rag.tryCommit();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                rag.tryRollback();
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
        } else if (null != index & key != null && value != null && id != null) {
            try {
                if (index.getIndexClass().equals(Vertex.class)) {
                    index.remove(key, value, (Element)graph.getVertex((Object)id));
                } else {
                    index.remove(key, value, (Element)graph.getEdge((Object)id));
                }
                rag.tryCommit();
                this.resultObject.put("queryTime", this.sh.stopWatch());
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                rag.tryRollback();
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
        } else {
            String msg = "A key, value, id, and type (vertex/edge) must be provided to lookup elements in an index";
            logger.info((Object)"A key, value, id, and type (vertex/edge) must be provided to lookup elements in an index");
            JSONObject error = this.generateErrorObject("A key, value, id, and type (vertex/edge) must be provided to lookup elements in an index");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @POST
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.post", absolute=true)
    public Response postIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName, JSONObject json) {
        this.setRequestObject(json);
        return this.postIndex(graphName, indexName);
    }

    @POST
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.post", absolute=true)
    public Response postIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName) {
        String msg;
        String clazz = null;
        HashSet<String> keys = null;
        Parameter[] indexParameters = new Parameter[]{};
        JSONObject theRequestObject = this.getRequestObject();
        Object temp = theRequestObject.opt("class");
        if (temp != null) {
            clazz = temp.toString();
        }
        if ((temp = theRequestObject.opt("keys")) != null) {
            try {
                JSONArray ks;
                if (temp instanceof String) {
                    ks = new JSONArray();
                    ks.put(temp);
                } else {
                    ks = (JSONArray)temp;
                }
                keys = new HashSet<String>();
                for (int i = 0; i < ks.length(); ++i) {
                    keys.add(ks.getString(i));
                }
            }
            catch (Exception e) {
                JSONObject error = this.generateErrorObject("Index keys must be in an array: " + temp);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
            }
        }
        if ((temp = theRequestObject.opt("params")) != null) {
            JSONObject idxParamsJson = (JSONObject)temp;
            ArrayList<Parameter> idxParamsList = new ArrayList<Parameter>();
            Iterator idxParamKeys = idxParamsJson.keys();
            while (idxParamKeys.hasNext()) {
                String nextIdxParamKey = (String)idxParamKeys.next();
                idxParamsList.add(new Parameter((Object)nextIdxParamKey, (Object)idxParamsJson.optString(nextIdxParamKey)));
            }
            indexParameters = new Parameter[idxParamsList.size()];
            idxParamsList.toArray(indexParameters);
        }
        Index index = this.getIndexFromGraph(graphName, indexName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        IndexableGraph graph = (IndexableGraph)rag.getGraph();
        if (null != index) {
            msg = "Index [" + indexName + "] on graph [" + graphName + "] already exists";
            logger.info((Object)msg);
            JSONObject error = this.generateErrorObject(msg);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        if (null != clazz) {
            Index newIndex;
            Class<Vertex> c;
            if (clazz.equals("vertex")) {
                c = Vertex.class;
            } else if (clazz.equals("edge")) {
                c = Edge.class;
            } else {
                JSONObject error = this.generateErrorObject("Index class must be either vertex or edge");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
            }
            try {
                newIndex = graph.createIndex(indexName, c, indexParameters);
                rag.tryCommit();
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
                rag.tryRollback();
                JSONObject error = this.generateErrorObject(e.getMessage());
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
            }
            try {
                this.resultObject.put("queryTime", this.sh.stopWatch());
                this.resultObject.put("results", (Object)IndexResource.createJSONObject(newIndex));
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
        }
        msg = "Class (vertex/edge) must be provided to create a new index";
        logger.info((Object)"Class (vertex/edge) must be provided to create a new index");
        JSONObject error = this.generateErrorObject("Class (vertex/edge) must be provided to create a new index");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        return Response.ok((Object)this.resultObject).build();
    }

    @PUT
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.put", absolute=true)
    public Response putElementInIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName, JSONObject json) {
        this.setRequestObject(json);
        return this.putElementInIndex(graphName, indexName);
    }

    @PUT
    @Path(value="/{indexName}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.indices.object.put", absolute=true)
    public Response putElementInIndex(@PathParam(value="graphname") String graphName, @PathParam(value="indexName") String indexName) {
        Index index = this.getIndexFromGraph(graphName, indexName);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        IndexableGraph graph = (IndexableGraph)rag.getGraph();
        if (index == null) {
            JSONObject error = this.generateErrorObject("Index not found.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
        }
        String key = null;
        Object value = null;
        String id = null;
        JSONObject theRequestObject = this.getRequestObject();
        Object temp = theRequestObject.opt("key");
        if (null != temp) {
            key = temp.toString();
        }
        if (null != (temp = theRequestObject.opt("value"))) {
            value = ElementHelper.getTypedPropertyValue((Object)temp.toString());
        }
        if (null != (temp = theRequestObject.opt("id"))) {
            id = temp.toString();
        }
        if (key != null && value != null && id != null) {
            try {
                if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
                    index.put(key, value, (Element)graph.getVertex((Object)id));
                    rag.tryCommit();
                } else if (Edge.class.isAssignableFrom(index.getIndexClass())) {
                    index.put(key, value, (Element)graph.getEdge((Object)id));
                    rag.tryCommit();
                } else {
                    rag.tryRollback();
                    JSONObject error = this.generateErrorObject("Index class must be either vertex or edge");
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
                }
                this.resultObject.put("queryTime", this.sh.stopWatch());
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
        } else {
            String msg = "A key, value, and id must be provided to add elements to an index";
            logger.info((Object)"A key, value, and id must be provided to add elements to an index");
            JSONObject error = this.generateErrorObject("A key, value, and id must be provided to add elements to an index");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    private static JSONObject createJSONObject(Index index) {
        HashMap<String, String> mapIndex = new HashMap<String, String>();
        mapIndex.put("name", index.getIndexName());
        if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
            mapIndex.put("class", "vertex");
        } else if (Edge.class.isAssignableFrom(index.getIndexClass())) {
            mapIndex.put("class", "edge");
        }
        return new JSONObject(mapIndex);
    }

    private Index getIndexFromGraph(String graphName, String name) {
        IndexableGraph idxGraph;
        Graph graph = this.getRexsterApplicationGraph(graphName).getUnwrappedGraph();
        IndexableGraph indexableGraph = idxGraph = graph instanceof IndexableGraph ? (IndexableGraph)graph : null;
        if (idxGraph == null) {
            JSONObject error = this.generateErrorObject("The requested graph is not of type IndexableGraph.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        Iterable indices = idxGraph.getIndices();
        for (Index index : indices) {
            if (!index.getIndexName().equals(name)) continue;
            return index;
        }
        return null;
    }
}

