/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public abstract class AbstractReporterConfig {
    public static final long DEFAULT_PERIOD = 60L;
    public static final String DEFAULT_TIME_UNIT = TimeUnit.SECONDS.toString();
    protected final MetricRegistry metricRegistry;
    protected SubnodeConfiguration registryConfiguration;
    protected long period;
    protected String timeUnit;
    protected String rateTimeUnitConversion;
    protected String durationTimeUnitConversion;
    protected String inclusion;
    protected String exclusion;

    public AbstractReporterConfig(HierarchicalConfiguration config, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        try {
            this.registryConfiguration = config.configurationAt("properties");
        }
        catch (IllegalArgumentException iae) {
            this.registryConfiguration = null;
        }
        this.readCommonConfiguration();
    }

    public TimeUnit getRealTimeUnit() {
        return TimeUnit.valueOf(this.timeUnit);
    }

    public TimeUnit getRealRateTimeUnitConversion() {
        return TimeUnit.valueOf(this.rateTimeUnitConversion);
    }

    public TimeUnit getRealDurationTimeUnitConversion() {
        return TimeUnit.valueOf(this.durationTimeUnitConversion);
    }

    public abstract boolean enable();

    public abstract void disable();

    private void readCommonConfiguration() {
        this.timeUnit = this.registryConfiguration == null ? DEFAULT_TIME_UNIT : this.registryConfiguration.getString("report-time-unit", DEFAULT_TIME_UNIT);
        this.period = this.registryConfiguration == null ? 60L : this.registryConfiguration.getLong("report-period", 60L);
        this.rateTimeUnitConversion = this.registryConfiguration == null ? DEFAULT_TIME_UNIT : this.registryConfiguration.getString("rates-time-unit", DEFAULT_TIME_UNIT);
        this.durationTimeUnitConversion = this.registryConfiguration == null ? DEFAULT_TIME_UNIT : this.registryConfiguration.getString("duration-time-unit", DEFAULT_TIME_UNIT);
        this.inclusion = this.registryConfiguration == null ? null : this.registryConfiguration.getString("includes", null);
        this.exclusion = this.registryConfiguration == null ? null : this.registryConfiguration.getString("excludes", null);
    }
}

