/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.structures.Tree;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe.GreedySideEffectPipe<S, Map> {
    Tree<Object> tree = new Tree();
    final List<PipeFunction> branchFunctions;
    int currentFunction = 0;

    public TreePipe(PipeFunction ... branchFunctions) {
        this.branchFunctions = branchFunctions.length == 0 ? null : Arrays.asList(branchFunctions);
    }

    public TreePipe(Tree tree, PipeFunction ... branchFunctions) {
        this(branchFunctions);
        this.tree = tree;
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        super.setStarts(starts);
        this.enablePath(true);
    }

    @Override
    public S processNextStart() {
        Object s = this.starts.next();
        List path = ((Pipe)this.starts).getCurrentPath();
        Tree depth = this.tree;
        for (int i = 0; i < path.size(); ++i) {
            Object object = path.get(i);
            if (null != this.branchFunctions) {
                object = this.branchFunctions.get(this.currentFunction).compute(object);
                this.currentFunction = (this.currentFunction + 1) % this.branchFunctions.size();
            }
            if (!depth.containsKey(object)) {
                depth.put(object, new Tree());
            }
            depth = (Tree)depth.get(object);
        }
        return (S)s;
    }

    @Override
    public Map getSideEffect() {
        return this.tree;
    }

    @Override
    public void reset() {
        this.tree = new Tree();
        this.currentFunction = 0;
        super.reset();
    }
}

