/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.exception.IllegalTypeArgumentException;
import org.jboss.windup.graph.model.WindupVertexFrame;

@Vetoed
public class Variables {
    private final Deque<Map<String, Iterable<WindupVertexFrame>>> deque = new LinkedList<Map<String, Iterable<WindupVertexFrame>>>();

    private Variables() {
    }

    public static Variables instance(GraphRewrite event) {
        Variables instance = (Variables)event.getRewriteContext().get(Variables.class);
        if (instance == null) {
            instance = new Variables();
            event.getRewriteContext().put(Variables.class, (Object)instance);
        }
        return instance;
    }

    public void push() {
        HashMap newFrame = new HashMap();
        this.deque.push(newFrame);
    }

    public void push(Map<String, Iterable<WindupVertexFrame>> frame) {
        this.deque.push(frame);
    }

    public Map<String, Iterable<WindupVertexFrame>> pop() {
        return this.deque.pop();
    }

    public Map<String, Iterable<WindupVertexFrame>> peek() {
        return this.deque.peek();
    }

    public void setSingletonVariable(String string, WindupVertexFrame frame) {
        this.setVariable(string, Collections.singletonList(frame));
    }

    public void setVariable(String name, Iterable<WindupVertexFrame> frames) {
        Map<String, Iterable<WindupVertexFrame>> frame = this.peek();
        if (!"default".equals(name) && this.findVariable(name) != null) {
            throw new IllegalArgumentException("Variable \"" + name + "\" has already been assigned and cannot be reassigned");
        }
        frame.put(name, frames);
    }

    public void removeVariable(String name) {
        Map<String, Iterable<WindupVertexFrame>> frame = this.peek();
        frame.remove(name);
    }

    public <T extends WindupVertexFrame> T findSingletonVariable(String name) {
        Iterable<WindupVertexFrame> frames = this.findVariable(name);
        if (null == frames) {
            throw new IllegalStateException("Variable not found: \"" + name + "\"");
        }
        Iterator<WindupVertexFrame> iterator = frames.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        WindupVertexFrame obj = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("More than one frame present under presumed singleton variable: " + name);
        }
        return (T)obj;
    }

    public <FRAMETYPE extends WindupVertexFrame> FRAMETYPE findSingletonVariable(Class<FRAMETYPE> type, String name) {
        Object frame = this.findSingletonVariable(name);
        if (type != null && !type.isAssignableFrom(frame.getClass())) {
            throw new IllegalTypeArgumentException(name, type, frame.getClass());
        }
        return (FRAMETYPE)frame;
    }

    public Iterable<WindupVertexFrame> findVariable(String name) {
        Map<String, Iterable<WindupVertexFrame>> frame;
        Iterable<WindupVertexFrame> result = null;
        Iterator<Map<String, Iterable<WindupVertexFrame>>> i$ = this.deque.iterator();
        while (i$.hasNext() && (result = (frame = i$.next()).get(name)) == null) {
        }
        return result;
    }

    public Iterable<WindupVertexFrame> findVariableOfType(Class<?> type) {
        for (Map<String, Iterable<WindupVertexFrame>> topOfStack : this.deque) {
            Iterator<Iterable<WindupVertexFrame>> i$ = topOfStack.values().iterator();
            if (!i$.hasNext()) continue;
            Iterable<WindupVertexFrame> frames = i$.next();
            for (WindupVertexFrame frame : frames) {
                if (type.isAssignableFrom(frame.getClass())) continue;
            }
            return frames;
        }
        return null;
    }
}

