/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.servlet;

import com.tinkerpop.rexster.gremlin.GremlinEvaluationJob;
import com.tinkerpop.rexster.gremlin.GremlinSessions;
import com.tinkerpop.rexster.gremlin.converter.ConsoleResultConverter;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EvaluatorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String newLineRegex = "(\r\n|\r|\n|\n\r)";
    private final RexsterApplication rexsterApplication;

    public EvaluatorServlet(RexsterApplication rexsterApplication) {
        this.rexsterApplication = rexsterApplication;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext sc = this.getServletContext();
        String code = request.getParameter("code");
        String logMessage = "[POST /exec?code=" + code.replaceAll(newLineRegex, " ") + "] ";
        String graphName = request.getParameter("g");
        if (code.isEmpty()) {
            sc.log(logMessage + "400 ERROR");
            response.setStatus(400);
            return;
        }
        String sessionId = request.getSession(true).getId();
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        sc.log(logMessage + "200 OK");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        System.setOut(out);
        try {
            GremlinEvaluationJob job = GremlinSessions.getSession(sessionId, graphName, this.rexsterApplication).evaluate(code);
            List lines = new ConsoleResultConverter(job.getOutputWriter()).convert(job.getResult());
            for (String line : lines) {
                out.println("==>" + line);
            }
        }
        catch (Exception e) {
            out.println(e.getMessage());
        }
        out.close();
    }
}

