/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;

    public OncRpcTcpClient(InetAddress host, int program, int version) throws OncRpcException, IOException {
        this(host, program, version, 0, 0);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        this(host, program, version, port, 0);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        this(host, program, version, port, bufferSize, -1);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize, int timeout) throws OncRpcException, IOException {
        super(host, program, version, port, 6);
        if (bufferSize == 0) {
            bufferSize = 8192;
        }
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socketHelper = new OncRpcTcpSocketHelper();
        this.socket = this.socketHelper.connect(host, this.port, timeout);
        this.socket.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.sendingXdr = new XdrTcpEncodingStream(this.socket, bufferSize);
        this.receivingXdr = new XdrTcpDecodingStream(this.socket, bufferSize);
    }

    public void close() throws OncRpcException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    public synchronized void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        int refreshesLeft = 1;
        while (refreshesLeft >= 0) {
            block16: {
                this.nextXid();
                OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, versionNumber, procedureNumber, this.auth);
                OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
                try {
                    this.socket.setSoTimeout(this.transmissionTimeout);
                    this.sendingXdr.beginEncoding(null, 0);
                    callHeader.xdrEncode(this.sendingXdr);
                    params.xdrEncode(this.sendingXdr);
                    if (this.timeout != 0) {
                        this.sendingXdr.endEncoding();
                    } else {
                        this.sendingXdr.endEncoding(false);
                    }
                }
                catch (IOException e) {
                    throw new OncRpcException(3, e.getLocalizedMessage());
                }
                if (this.timeout == 0) {
                    return;
                }
                try {
                    while (true) {
                        this.socket.setSoTimeout(this.timeout);
                        this.receivingXdr.beginDecoding();
                        this.socket.setSoTimeout(this.transmissionTimeout);
                        try {
                            replyHeader.xdrDecode(this.receivingXdr);
                        }
                        catch (OncRpcException e) {
                            this.receivingXdr.endDecoding();
                            throw e;
                        }
                        if (replyHeader.messageId == callHeader.messageId) break;
                        this.receivingXdr.endDecoding();
                    }
                    if (!replyHeader.successfullyAccepted()) {
                        this.receivingXdr.endDecoding();
                        if (refreshesLeft <= 0 || replyHeader.replyStatus != 1 || replyHeader.rejectStatus != 1 || this.auth == null || !this.auth.canRefreshCred()) {
                            throw replyHeader.newException();
                        }
                        break block16;
                    }
                    try {
                        result.xdrDecode(this.receivingXdr);
                    }
                    catch (OncRpcException e) {
                        this.receivingXdr.endDecoding();
                        throw e;
                    }
                    this.receivingXdr.endDecoding();
                    return;
                }
                catch (InterruptedIOException e) {
                    throw new OncRpcTimeoutException();
                }
                catch (IOException e) {
                    throw new OncRpcException(4, e.getLocalizedMessage());
                }
            }
            --refreshesLeft;
        }
    }

    public synchronized void batchCall(int procedureNumber, XdrAble params, boolean flush) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, this.version, procedureNumber, this.auth);
        try {
            this.socket.setSoTimeout(this.transmissionTimeout);
            this.sendingXdr.beginEncoding(null, 0);
            callHeader.xdrEncode(this.sendingXdr);
            params.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(flush);
        }
        catch (IOException e) {
            throw new OncRpcException(3, e.getLocalizedMessage());
        }
    }

    public void setTimeout(int milliseconds) {
        super.setTimeout(milliseconds);
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.receivingXdr.setCharacterEncoding(characterEncoding);
        this.sendingXdr.setCharacterEncoding(characterEncoding);
    }

    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }
}

