/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.SingleCommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.impl.context.UIExecutionContextImpl;
import org.jboss.forge.addon.ui.impl.context.UINavigationContextImpl;
import org.jboss.forge.addon.ui.impl.controller.AbstractCommandController;
import org.jboss.forge.addon.ui.impl.controller.CommandControllerFactoryImpl;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.NavigationResultEntry;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.addon.ui.wizard.WizardExecutionListener;
import org.jboss.forge.furnace.addons.AddonRegistry;

class WizardCommandControllerImpl
extends AbstractCommandController
implements WizardCommandController {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<WizardStepEntry> flow = new ArrayList<WizardStepEntry>();
    private final LinkedList<WizardStepEntry> subflow = new LinkedList();
    private final Set<Integer> usedSubflows = new HashSet<Integer>();
    private int flowPointer = 0;
    private final CommandControllerFactoryImpl controllerFactory;

    public WizardCommandControllerImpl(UIContext context, AddonRegistry addonRegistry, UIRuntime runtime, UIWizard initialCommand, CommandControllerFactoryImpl controllerFactory) {
        super(addonRegistry, runtime, (UICommand)initialCommand, context);
        this.controllerFactory = controllerFactory;
        this.flow.add(this.createEntry((UICommand)initialCommand, false));
    }

    private void refreshFlow() {
        try {
            this.initialize();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int currentFlowPointer = this.flowPointer;
        this.flowPointer = 0;
        while (this.canMoveToNextStep()) {
            try {
                this.next().initialize();
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        this.cleanSubsequentStalePages();
        this.flowPointer = currentFlowPointer;
    }

    public void initialize() throws Exception {
        this.getCurrentController().initialize();
    }

    public boolean isInitialized() {
        return this.getCurrentController().isInitialized();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute() throws Exception {
        this.assertInitialized();
        this.assertValid();
        UIProgressMonitor progressMonitor = this.runtime.createProgressMonitor(this.context);
        UIPrompt prompt = this.runtime.createPrompt(this.context);
        UIExecutionContextImpl executionContext = new UIExecutionContextImpl(this.context, progressMonitor, prompt);
        LinkedHashSet<CommandExecutionListener> listeners = new LinkedHashSet<CommandExecutionListener>();
        listeners.addAll(this.context.getListeners());
        for (CommandExecutionListener listener : this.addonRegistry.getServices(CommandExecutionListener.class)) {
            listeners.add(listener);
        }
        LinkedList<Result> results = new LinkedList<Result>();
        try {
            this.firePreWizardExecuted(executionContext, listeners);
            for (WizardStepEntry entry : this.flow) {
                CommandController controller = entry.controller;
                if (!progressMonitor.isCancelled()) {
                    UICommand command = controller.getCommand();
                    try {
                        this.firePreCommandExecuted(executionContext, listeners, command);
                        Result currentResult = command.execute((UIExecutionContext)executionContext);
                        results.add(currentResult);
                        this.firePostCommandExecuted(executionContext, listeners, command, currentResult);
                        continue;
                    }
                    catch (Exception e) {
                        this.firePostCommandFailure(executionContext, listeners, command, e);
                        throw e;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            this.firePostWizardFailure(executionContext, listeners, e);
            throw e;
        }
        CompositeResult result = results.size() == 1 ? (Result)results.get(0) : Results.aggregate(results);
        this.firePostWizardExecuted(executionContext, listeners, (Result)result);
        return result;
    }

    protected void firePreWizardExecuted(UIExecutionContext executionContext, Set<CommandExecutionListener> listeners) {
        for (CommandExecutionListener listener : listeners) {
            if (!(listener instanceof WizardExecutionListener)) continue;
            ((WizardExecutionListener)listener).preWizardExecuted((UIWizard)this.initialCommand, executionContext);
        }
    }

    protected void firePostWizardFailure(UIExecutionContext executionContext, Set<CommandExecutionListener> listeners, Exception e) {
        for (CommandExecutionListener listener : listeners) {
            if (!(listener instanceof WizardExecutionListener)) continue;
            ((WizardExecutionListener)listener).postWizardFailure((UIWizard)this.initialCommand, executionContext, (Throwable)e);
        }
    }

    protected void firePostWizardExecuted(UIExecutionContext executionContext, Set<CommandExecutionListener> listeners, Result currentResult) {
        for (CommandExecutionListener listener : listeners) {
            if (!(listener instanceof WizardExecutionListener)) continue;
            ((WizardExecutionListener)listener).postWizardExecuted((UIWizard)this.initialCommand, executionContext, currentResult);
        }
    }

    public List<UIMessage> validate() {
        return this.getCurrentController().validate();
    }

    public boolean isValid() {
        return this.getCurrentController().isValid();
    }

    public CommandController setValueFor(String inputName, Object value) throws IllegalArgumentException {
        this.getCurrentController().setValueFor(inputName, value);
        return this;
    }

    public Object getValueFor(String inputName) throws IllegalArgumentException {
        return this.getCurrentController().getValueFor(inputName);
    }

    public Map<String, InputComponent<?, ?>> getInputs() {
        return this.getCurrentController().getInputs();
    }

    public UICommandMetadata getMetadata() {
        return this.getCurrentController().getMetadata();
    }

    public UICommandMetadata getInitialMetadata() {
        return this.flow.get((int)0).controller.getMetadata();
    }

    public boolean isEnabled() {
        return this.getCurrentController().isEnabled();
    }

    public UICommand getCommand() {
        return this.getCurrentController().getCommand();
    }

    public void close() throws Exception {
        this.context.close();
        this.subflow.clear();
        this.flow.clear();
        this.usedSubflows.clear();
    }

    public boolean canMoveToNextStep() {
        this.assertInitialized();
        if (!this.isValid()) {
            return false;
        }
        NavigationResultEntry[] next = this.getNextFrom(this.getCurrentController().getCommand());
        return next != null || !this.subflow.isEmpty() || this.usedSubflows.contains(this.flowPointer);
    }

    public boolean canMoveToPreviousStep() {
        this.assertInitialized();
        return this.flowPointer > 0;
    }

    public boolean canExecute() {
        this.assertInitialized();
        this.refreshFlow();
        for (WizardStepEntry entry : this.flow) {
            if (entry.controller.canExecute()) continue;
            return false;
        }
        CommandController lastController = this.flow.get((int)(this.flow.size() - 1)).controller;
        if (lastController.isInitialized()) {
            NavigationResultEntry[] next = this.getNextFrom(this.flow.get((int)(this.flow.size() - 1)).controller.getCommand());
            return next == null && this.subflow.isEmpty();
        }
        return false;
    }

    public WizardCommandController next() throws Exception {
        this.assertInitialized();
        this.assertValid();
        WizardStepEntry currentEntry = this.getCurrentEntry();
        WizardStepEntry nextEntry = this.getNextEntry();
        Object[] result = this.getNextFrom(currentEntry.controller.getCommand());
        if (nextEntry == null) {
            currentEntry.next = result;
            this.addNextFlowStep((NavigationResultEntry[])result);
        } else if (!Arrays.equals(currentEntry.next, result)) {
            currentEntry.next = result;
            this.cleanSubsequentStalePages();
            this.addNextFlowStep((NavigationResultEntry[])result);
        } else {
            UICommand command;
            if (result == null) {
                if (this.subflow.isEmpty()) {
                    command = null;
                } else {
                    UICommandMetadata metadata = this.subflow.peek().controller.getCommand().getMetadata(this.context);
                    command = this.createCommand(metadata.getType());
                }
            } else {
                command = this.createCommand((NavigationResultEntry)result[0]);
            }
            if (command != null) {
                SingleCommandController ctrl = this.controllerFactory.doCreateSingleController(this.context, this.runtime, command);
                ctrl.initialize();
                Set currentInputsKeySet = nextEntry.controller.getInputs().keySet();
                Set keySet = ctrl.getInputs().keySet();
                if (!currentInputsKeySet.containsAll(keySet) || !keySet.containsAll(currentInputsKeySet)) {
                    this.cleanSubsequentStalePages();
                    this.addNextFlowStep((NavigationResultEntry[])result);
                }
            }
        }
        ++this.flowPointer;
        return this;
    }

    private void cleanSubsequentStalePages() {
        if (this.flowPointer == 0) {
            this.flow.subList(1, this.flow.size()).clear();
            this.subflow.clear();
        } else {
            ListIterator<WizardStepEntry> it = this.flow.listIterator(this.flowPointer + 1);
            int subflowIdx = 0;
            while (it.hasNext()) {
                WizardStepEntry entry = (WizardStepEntry)it.next();
                if (entry.subflowHead && !this.subflow.contains(entry)) {
                    this.subflow.add(subflowIdx++, entry);
                }
                it.remove();
            }
        }
    }

    private void addNextFlowStep(NavigationResultEntry[] result) {
        WizardStepEntry next;
        if (result == null) {
            if (this.subflow.isEmpty()) {
                throw new IllegalStateException("No next step found");
            }
            next = this.subflow.pop();
            this.usedSubflows.add(this.flowPointer);
        } else {
            next = this.createEntry(result[0], false);
            for (int i = 1; i < result.length; ++i) {
                WizardStepEntry subflowEntry = this.createEntry(result[i], true);
                if (this.subflow.contains(subflowEntry)) continue;
                this.subflow.add(subflowEntry);
            }
        }
        this.flow.add(next);
    }

    public WizardCommandController previous() throws IllegalStateException {
        this.assertInitialized();
        if (!this.canMoveToPreviousStep()) {
            throw new IllegalStateException("No previous step found");
        }
        --this.flowPointer;
        return this;
    }

    protected int getFlowPointer() {
        return this.flowPointer;
    }

    protected void setFlowPointer(int flowPointer) {
        this.flowPointer = flowPointer;
    }

    private WizardStepEntry getCurrentEntry() {
        return this.flow.get(this.flowPointer);
    }

    private WizardStepEntry getNextEntry() {
        int nextIdx = this.flowPointer + 1;
        return nextIdx < this.flow.size() ? this.flow.get(nextIdx) : null;
    }

    private CommandController getCurrentController() {
        return this.getCurrentEntry().controller;
    }

    private WizardStepEntry createEntry(NavigationResultEntry entry, boolean subflowHead) {
        UICommand command = this.createCommand(entry);
        return this.createEntry(command, subflowHead);
    }

    private UICommand createCommand(NavigationResultEntry entry) {
        UICommand command = entry.getCommand(this.addonRegistry, this.context);
        return command;
    }

    private UICommand createCommand(Class<? extends UICommand> commandClass) {
        UICommand command = (UICommand)this.addonRegistry.getServices(commandClass).get();
        return command;
    }

    private WizardStepEntry createEntry(UICommand command, boolean subflowHead) {
        SingleCommandController controller = this.controllerFactory.doCreateSingleController(this.context, this.runtime, command);
        return new WizardStepEntry((CommandController)controller, subflowHead);
    }

    private NavigationResultEntry[] getNextFrom(UICommand command) {
        NavigationResultEntry[] result = null;
        if (command instanceof UIWizard) {
            NavigationResult next;
            try {
                next = ((UIWizard)command).next((UINavigationContext)new UINavigationContextImpl(this.context));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Cannot fetch the next steps from " + command, e);
                next = null;
            }
            if (next != null) {
                result = next.getNext();
            }
        }
        return result;
    }

    private static class WizardStepEntry {
        final CommandController controller;
        NavigationResultEntry[] next;
        final boolean subflowHead;

        public WizardStepEntry(CommandController controller, boolean subflowHead) {
            this.controller = controller;
            this.subflowHead = subflowHead;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.controller == null ? 0 : this.controller.hashCode());
            result = 31 * result + Arrays.hashCode(this.next);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WizardStepEntry other = (WizardStepEntry)obj;
            if (this.controller == null ? other.controller != null : !this.controller.equals(other.controller)) {
                return false;
            }
            return Arrays.equals(this.next, other.next);
        }
    }
}

