/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import com.google.common.base.Supplier;
import com.google.common.collect.ForwardingMap;
import java.util.HashMap;
import java.util.Map;

public class DefaultValueMap<K, V>
extends ForwardingMap<K, V> {
    private final Map<K, V> delegate;
    private final Supplier<V> defaultValueSupplier;

    public static <K, V> DefaultValueMap<K, V> of(Map<K, V> delegate, Supplier<V> defaultValueSupplier) {
        return new DefaultValueMap<K, V>(delegate, defaultValueSupplier);
    }

    public static <K, V> DefaultValueMap<K, V> hashMapWithDefaultValue(Supplier<V> defaultValueSupplier) {
        return new DefaultValueMap(new HashMap(), defaultValueSupplier);
    }

    private DefaultValueMap(Map<K, V> delegate, Supplier<V> defaultValueSupplier) {
        this.delegate = delegate;
        this.defaultValueSupplier = defaultValueSupplier;
    }

    public V get(Object key) {
        V value = this.delegate.get(key);
        if (value == null) {
            this.delegate.put(key, this.defaultValueSupplier.get());
            value = this.delegate.get(key);
        }
        return value;
    }

    protected Map<K, V> delegate() {
        return this.delegate;
    }
}

