/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.MutableCommandRegistry;
import org.jboss.aesh.io.Resource;

@CommandDefinition(name="add-command", description="specify a groovy command file ")
public class GroovyCommand
implements Command<CommandInvocation> {
    private CommandInvocation commandInvocation;
    @Arguments
    private List<Resource> files;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        this.commandInvocation = commandInvocation;
        if (this.files != null && this.files.size() > 0 && this.files.get(0).isLeaf()) {
            Resource f = (Resource)this.files.get(0).resolve(commandInvocation.getAeshContext().getCurrentWorkingDirectory()).get(0);
            this.loadCommand(f);
        }
        return CommandResult.SUCCESS;
    }

    private void loadCommand(Resource file) {
        try {
            ClassLoader parent = this.getClass().getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(file.read(), file.getName());
            if (groovyClass.isAnnotationPresent(CommandDefinition.class)) {
                boolean correctClass = false;
                for (Class<?> groovyInterface : groovyClass.getInterfaces()) {
                    if (!groovyInterface.equals(Command.class)) continue;
                    correctClass = true;
                }
                if (correctClass) {
                    if (this.commandInvocation.getCommandRegistry() instanceof MutableCommandRegistry) {
                        ((MutableCommandRegistry)this.commandInvocation.getCommandRegistry()).addCommand(groovyClass);
                        this.commandInvocation.getShell().out().println("Added " + groovyClass.getName() + " to commands");
                    }
                } else {
                    this.commandInvocation.getShell().out().println("Groovy command do not implement Command interface");
                }
            } else {
                this.commandInvocation.getShell().out().println("Groovy command do not contain CommandDefinition annotation");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

