/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.ShellMessages;
import org.jboss.forge.addon.shell.aesh.AbstractShellInteraction;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.furnace.util.Strings;

class CommandAdapter
implements Command<CommandInvocation> {
    private static final Logger log = Logger.getLogger(CommandAdapter.class.getName());
    private final ShellImpl shell;
    private final ShellContext shellContext;
    private final AbstractShellInteraction interaction;

    public CommandAdapter(ShellImpl shell, ShellContext shellContext, AbstractShellInteraction interaction) {
        this.shell = shell;
        this.shellContext = shellContext;
        this.interaction = interaction;
    }

    public List<UIMessage> validate() {
        return this.interaction.getController().validate();
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        Map attributeMap = this.shellContext.getAttributeMap();
        attributeMap.put(CommandInvocation.class, commandInvocation);
        boolean failure = false;
        if (this.shellContext.isInteractive()) {
            this.interaction.promptRequiredMissingValues(this.shell);
        }
        if (this.interaction.getController().isValid()) {
            Object result;
            Result commandResult = null;
            try {
                commandResult = this.interaction.getController().execute();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to execute [" + this.interaction.getName() + "] due to exception.", e);
                commandResult = Results.fail((String)e.getMessage(), (Throwable)e);
            }
            failure = this.displayResult(commandResult);
            UISelection selection = this.interaction.getContext().getSelection();
            if (selection != null && !selection.isEmpty() && (result = selection.get()) instanceof Resource) {
                this.shell.setCurrentResource((Resource)result);
            }
        } else {
            List messages = this.interaction.getController().validate();
            for (UIMessage message : messages) {
                if (message.getSeverity() != UIMessage.Severity.ERROR) continue;
                failure = true;
                ShellMessages.error(this.shell.getConsole().getShell().err(), message.getDescription());
            }
        }
        return failure ? CommandResult.FAILURE : CommandResult.SUCCESS;
    }

    private boolean displayResult(Result result) {
        boolean failure = false;
        if (result instanceof CompositeResult) {
            for (Result thisResult : ((CompositeResult)result).getResults()) {
                if (this.displayResult(thisResult)) continue;
                failure = true;
            }
        } else if (result != null && !Strings.isNullOrEmpty((String)result.getMessage())) {
            if (result instanceof Failed) {
                ShellMessages.error(this.shell.getConsole().getShell().err(), result.getMessage());
                log.log(Level.SEVERE, result.getMessage(), ((Failed)result).getException());
                failure = true;
            } else {
                ShellMessages.success(this.shell.getConsole().getShell().out(), result.getMessage());
                failure = false;
            }
        }
        return failure;
    }
}

