/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.nio.file.Path;
import java.nio.file.Paths;

public class WindupPathUtil {
    public static Path getWindupUserDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            return null;
        }
        return Paths.get(userHome, new String[0]).resolve(".windup");
    }

    public static Path getWindupUserRulesDir() {
        Path windupUserDir = WindupPathUtil.getWindupUserDir();
        if (windupUserDir == null) {
            return null;
        }
        return windupUserDir.resolve("rules");
    }

    public static Path getWindupIgnoreListDir() {
        Path windupUserDir = WindupPathUtil.getWindupUserDir();
        if (windupUserDir == null) {
            return null;
        }
        return windupUserDir.resolve("ignore");
    }

    public static Path getWindupHome() {
        String forgeHome = System.getProperty("forge.home");
        if (forgeHome == null) {
            return null;
        }
        return Paths.get(forgeHome, new String[0]);
    }

    public static Path getWindupHomeRules() {
        Path windupHome = WindupPathUtil.getWindupHome();
        if (windupHome == null) {
            return null;
        }
        return windupHome.resolve("rules");
    }

    public static Path getWindupHomeIgnoreListDir() {
        Path windupHome = WindupPathUtil.getWindupHome();
        if (windupHome == null) {
            return null;
        }
        return windupHome.resolve("ignore");
    }

    public static String cleanFileName(String badFileName) {
        if (badFileName == null) {
            return null;
        }
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (Character.isJavaIdentifierPart((int)c)) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    public static String classFilePathToClassname(String classFilePath) {
        if (classFilePath == null) {
            return null;
        }
        int pos = classFilePath.lastIndexOf(".class");
        if (pos < 0) {
            throw new IllegalArgumentException("Not a .class file path: " + classFilePath);
        }
        return classFilePath.substring(0, pos).replace('/', '.').replace('\\', '.');
    }
}

