/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexListInternal;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexLongList;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class VertexArrayList
implements VertexListInternal {
    public static final Comparator<TitanVertex> VERTEX_ID_COMPARATOR = new Comparator<TitanVertex>(){

        @Override
        public int compare(TitanVertex o1, TitanVertex o2) {
            return Long.compare(o1.getLongId(), o2.getLongId());
        }
    };
    private final StandardTitanTx tx;
    private List<TitanVertex> vertices;
    private boolean sorted;

    private VertexArrayList(StandardTitanTx tx, List<TitanVertex> vertices, boolean sorted) {
        Preconditions.checkArgument((tx != null && vertices != null ? 1 : 0) != 0);
        this.tx = tx;
        this.vertices = vertices;
        this.sorted = sorted;
    }

    public VertexArrayList(StandardTitanTx tx) {
        Preconditions.checkNotNull((Object)tx);
        this.tx = tx;
        this.vertices = new ArrayList<TitanVertex>();
        this.sorted = true;
    }

    @Override
    public void add(TitanVertex n) {
        if (!this.vertices.isEmpty()) {
            this.sorted = this.sorted && this.vertices.get(this.vertices.size() - 1).getLongId() <= n.getLongId();
        }
        this.vertices.add(n);
    }

    @Override
    public long getID(int pos) {
        return this.vertices.get(pos).getLongId();
    }

    @Override
    public LongArrayList getIDs() {
        return VertexArrayList.toLongList(this.vertices);
    }

    @Override
    public TitanVertex get(int pos) {
        return this.vertices.get(pos);
    }

    @Override
    public void sort() {
        if (this.sorted) {
            return;
        }
        Collections.sort(this.vertices, VERTEX_ID_COMPARATOR);
        this.sorted = true;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public VertexList subList(int fromPosition, int length) {
        return new VertexArrayList(this.tx, this.vertices.subList(fromPosition, fromPosition + length), this.sorted);
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public void addAll(VertexList vertexlist) {
        VertexArrayList other;
        Preconditions.checkArgument((boolean)(vertexlist instanceof VertexArrayList), (Object)"Only supporting union of identical lists.");
        VertexArrayList vertexArrayList = other = vertexlist instanceof VertexArrayList ? (VertexArrayList)vertexlist : ((VertexLongList)vertexlist).toVertexArrayList();
        if (this.sorted && other.isSorted()) {
            this.vertices = (ArrayList)IterablesUtil.mergeSort(this.vertices, other.vertices, VERTEX_ID_COMPARATOR);
        } else {
            this.sorted = false;
            this.vertices.addAll(other.vertices);
        }
    }

    public VertexLongList toVertexLongList() {
        LongArrayList list = VertexArrayList.toLongList(this.vertices);
        return new VertexLongList(this.tx, list, this.sorted);
    }

    @Override
    public Iterator<TitanVertex> iterator() {
        return Iterators.unmodifiableIterator(this.vertices.iterator());
    }

    private static final LongArrayList toLongList(List<TitanVertex> vertices) {
        LongArrayList result = new LongArrayList(vertices.size());
        for (TitanVertex n : vertices) {
            result.add(n.getLongId());
        }
        return result;
    }
}

