/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.graphite;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.net.SocketFactory;

public class Graphite
implements Closeable {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private Socket socket;
    private Writer writer;
    private int failures;

    public Graphite(InetSocketAddress address) {
        this(address, SocketFactory.getDefault());
    }

    public Graphite(InetSocketAddress address, SocketFactory socketFactory) {
        this.address = address;
        this.socketFactory = socketFactory;
    }

    public void connect() throws IllegalStateException, IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        this.socket = this.socketFactory.createSocket(this.address.getAddress(), this.address.getPort());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), UTF_8));
    }

    public void send(String name, String value, long timestamp) throws IOException {
        try {
            this.writer.write(this.sanitize(name));
            this.writer.write(32);
            this.writer.write(this.sanitize(value));
            this.writer.write(32);
            this.writer.write(Long.toString(timestamp));
            this.writer.write(10);
            this.writer.flush();
            this.failures = 0;
        }
        catch (IOException e) {
            ++this.failures;
            throw e;
        }
    }

    public int getFailures() {
        return this.failures;
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.writer = null;
    }

    protected String sanitize(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }
}

