/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileModelService;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.maven.dao.MavenModelService;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.MarshallingException;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoverMavenProjectsRuleProvider
extends WindupRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverMavenProjectsRuleProvider.class);
    private static final Map<String, String> namespaces = new HashMap<String, String>();

    public RulePhase getPhase() {
        return RulePhase.DISCOVERY;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverXmlFilesRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderWith fileWhen = Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"pom.xml");
        AbstractIterationOperation<XmlFileModel> evaluatePomFiles = new AbstractIterationOperation<XmlFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
                block2: {
                    MavenProjectModel mavenProjectModel;
                    GraphContext graphContext;
                    block3: {
                        graphContext = event.getGraphContext();
                        mavenProjectModel = DiscoverMavenProjectsRuleProvider.this.extractMavenProjectModel(graphContext, payload);
                        if (mavenProjectModel == null) break block2;
                        ArchiveModel archiveModel = payload.getParentArchive();
                        if (archiveModel == null) break block3;
                        archiveModel.setProjectModel((ProjectModel)mavenProjectModel);
                        mavenProjectModel.setRootFileModel((FileModel)archiveModel);
                        for (FileModel f : archiveModel.getContainedFileModels()) {
                            if (f instanceof ArchiveModel || f.getProjectModel() != null) continue;
                            f.setProjectModel((ProjectModel)mavenProjectModel);
                            mavenProjectModel.addFileModel(f);
                        }
                        break block2;
                    }
                    File parentFile = payload.asFile().getParentFile();
                    FileModel parentFileModel = new FileModelService(graphContext).findByPath(parentFile.getAbsolutePath());
                    if (parentFileModel == null) break block2;
                    parentFileModel.setProjectModel((ProjectModel)mavenProjectModel);
                    mavenProjectModel.addFileModel(parentFileModel);
                    mavenProjectModel.setRootFileModel(parentFileModel);
                    for (FileModel childFile : parentFileModel.getFilesInDirectory()) {
                        DiscoverMavenProjectsRuleProvider.this.addFilesToModel(mavenProjectModel, childFile);
                    }
                }
            }

            public String toString() {
                return "ScanMavenProject";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)fileWhen).perform((Operation)evaluatePomFiles);
    }

    private void addFilesToModel(MavenProjectModel mavenProjectModel, FileModel fileModel) {
        for (FileModel childFile : fileModel.getFilesInDirectory()) {
            String filename = childFile.getFileName();
            if (!filename.equals("pom.xml")) continue;
            return;
        }
        fileModel.setProjectModel((ProjectModel)mavenProjectModel);
        mavenProjectModel.addFileModel(fileModel);
        for (FileModel childFile : fileModel.getFilesInDirectory()) {
            this.addFilesToModel(mavenProjectModel, childFile);
        }
    }

    public MavenProjectModel extractMavenProjectModel(GraphContext context, XmlFileModel xmlResourceModel) {
        MavenModelService mavenModelService;
        MavenProjectModel mavenProjectModel;
        File myFile = xmlResourceModel.asFile();
        Document document = xmlResourceModel.asDocument();
        String modelVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:modelVersion", namespaces);
        String name = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:name", namespaces);
        String description = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:description", namespaces);
        String url = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:url", namespaces);
        String groupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:groupId", namespaces);
        String artifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:artifactId", namespaces);
        String version = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:version", namespaces);
        String parentGroupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:groupId", namespaces);
        String parentArtifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:artifactId", namespaces);
        String parentVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:version", namespaces);
        if (StringUtils.isBlank((String)groupId) && StringUtils.isNotBlank((String)parentGroupId)) {
            groupId = parentGroupId;
        }
        if (StringUtils.isBlank((String)version) && StringUtils.isNotBlank((String)parentVersion)) {
            version = parentVersion;
        }
        if ((mavenProjectModel = (mavenModelService = new MavenModelService(context)).findByGroupArtifactVersion(groupId, artifactId, version)) == null) {
            mavenProjectModel = mavenModelService.createMavenStub(groupId, artifactId, version);
            mavenProjectModel.addMavenPom(xmlResourceModel);
        } else {
            boolean found = false;
            for (XmlFileModel foundPom : mavenProjectModel.getMavenPom()) {
                File foundPomFile = foundPom.asFile();
                if (!foundPomFile.getAbsoluteFile().equals(myFile)) continue;
                found = true;
                break;
            }
            if (!found) {
                mavenProjectModel.addMavenPom(xmlResourceModel);
            }
        }
        mavenProjectModel.setName(this.getReadableNameForProject(name, groupId, artifactId, version));
        if (StringUtils.isNotBlank((String)description)) {
            mavenProjectModel.setDescription(StringUtils.trim((String)description));
        }
        if (StringUtils.isNotBlank((String)url)) {
            mavenProjectModel.setURL(StringUtils.trim((String)url));
        }
        if (StringUtils.isNotBlank((String)modelVersion)) {
            mavenProjectModel.setSpecificationVersion(modelVersion);
        }
        if (StringUtils.isNotBlank((String)parentGroupId)) {
            MavenProjectModel parent = mavenModelService.findByGroupArtifactVersion(parentGroupId = this.resolveProperty(document, namespaces, parentGroupId, version), parentArtifactId = this.resolveProperty(document, namespaces, parentArtifactId, version), parentVersion = this.resolveProperty(document, namespaces, parentVersion, version));
            if (parent == null) {
                parent = mavenModelService.createMavenStub(parentGroupId, parentArtifactId, parentVersion);
                parent.setName(this.getReadableNameForProject(null, parentGroupId, parentArtifactId, parentVersion));
            }
            mavenProjectModel.setParentMavenPOM(parent);
        }
        NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)"/pom:project/pom:dependencies/pom:dependency", namespaces);
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = nodes.item(i);
            String dependencyGroupId = XmlUtil.xpathExtract((Node)node, (String)"./pom:groupId", namespaces);
            String dependencyArtifactId = XmlUtil.xpathExtract((Node)node, (String)"./pom:artifactId", namespaces);
            String dependencyVersion = XmlUtil.xpathExtract((Node)node, (String)"./pom:version", namespaces);
            String dependencyClassifier = XmlUtil.xpathExtract((Node)node, (String)"./pom:classifier", namespaces);
            String dependencyScope = XmlUtil.xpathExtract((Node)node, (String)"./pom:scope", namespaces);
            String dependencyType = XmlUtil.xpathExtract((Node)node, (String)"./pom:type", namespaces);
            dependencyGroupId = this.resolveProperty(document, namespaces, dependencyGroupId, version);
            dependencyArtifactId = this.resolveProperty(document, namespaces, dependencyArtifactId, version);
            dependencyVersion = this.resolveProperty(document, namespaces, dependencyVersion, version);
            if (!StringUtils.isNotBlank((String)dependencyGroupId)) continue;
            MavenProjectModel dependency = mavenModelService.findByGroupArtifactVersion(dependencyGroupId, dependencyArtifactId, dependencyVersion);
            if (dependency == null) {
                dependency = mavenModelService.createMavenStub(dependencyGroupId, dependencyArtifactId, dependencyVersion);
                dependency.setName(this.getReadableNameForProject(null, dependencyGroupId, dependencyArtifactId, dependencyVersion));
            }
            ProjectDependencyModel projectDep = (ProjectDependencyModel)context.getFramed().addVertex(null, ProjectDependencyModel.class);
            projectDep.setClassifier(dependencyClassifier);
            projectDep.setScope(dependencyScope);
            projectDep.setType(dependencyType);
            projectDep.setProject((ProjectModel)dependency);
            mavenProjectModel.addDependency(projectDep);
        }
        return mavenProjectModel;
    }

    private String getReadableNameForProject(String mavenName, String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)mavenName)) {
            sb.append(mavenName);
            sb.append(" (");
        }
        sb.append(groupId).append(":").append(artifactId).append(":").append(version);
        if (StringUtils.isNotBlank((String)mavenName)) {
            sb.append(")");
        }
        return sb.toString();
    }

    private String resolveProperty(Document document, Map<String, String> namespaces, String property, String projectVersion) throws MarshallingException {
        if (StringUtils.startsWith((String)property, (String)"${")) {
            String propertyName = StringUtils.removeStart((String)property, (String)"${");
            switch (propertyName = StringUtils.removeEnd((String)propertyName, (String)"}")) {
                case "pom.version": 
                case "project.version": {
                    return projectVersion;
                }
            }
            NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)("//pom:properties/pom:" + propertyName), namespaces);
            if (nodes.getLength() == 0 || nodes.item(0) == null) {
                LOG.warning("Expected: " + property + " but it wasn't found in the POM.");
            } else {
                Node node = nodes.item(0);
                String value = node.getTextContent();
                return value;
            }
        }
        return property;
    }

    static {
        namespaces.put("pom", "http://maven.apache.org/POM/4.0.0");
    }
}

