/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.PackageReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.PackageDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class CollapseImportsTransform
implements IAstTransform {
    private final DecompilerSettings _settings;

    public CollapseImportsTransform(DecompilerContext context) {
        this._settings = context.getSettings();
    }

    @Override
    public void run(AstNode root) {
        String filePackage;
        if (!(root instanceof CompilationUnit)) {
            return;
        }
        CompilationUnit compilationUnit = (CompilationUnit)root;
        if (this._settings.getForceExplicitImports()) {
            this.removeRedundantImports(compilationUnit);
            return;
        }
        AstNodeCollection<ImportDeclaration> imports = compilationUnit.getImports();
        PackageDeclaration packageDeclaration = compilationUnit.getChildByRole(Roles.PACKAGE);
        String string = filePackage = packageDeclaration.isNull() ? null : packageDeclaration.getName();
        if (imports.isEmpty()) {
            return;
        }
        LinkedHashSet<String> newImports = new LinkedHashSet<String>();
        ArrayList<ImportDeclaration> removedImports = new ArrayList<ImportDeclaration>();
        for (ImportDeclaration oldImport : imports) {
            TypeReference type;
            Identifier importedType = oldImport.getImportIdentifier();
            if (importedType == null || importedType.isNull() || (type = oldImport.getUserData(Keys.TYPE_REFERENCE)) == null) continue;
            String packageName = type.getPackageName();
            if (!(StringUtilities.isNullOrEmpty((String)packageName) || StringUtilities.equals((String)packageName, (String)"java.lang") || StringUtilities.equals((String)packageName, (String)filePackage))) {
                newImports.add(packageName);
            }
            removedImports.add(oldImport);
        }
        if (removedImports.isEmpty()) {
            return;
        }
        ImportDeclaration lastRemoved = (ImportDeclaration)removedImports.get(removedImports.size() - 1);
        for (String packageName : newImports) {
            compilationUnit.insertChildAfter(lastRemoved, new ImportDeclaration(PackageReference.parse(packageName)), CompilationUnit.IMPORT_ROLE);
        }
        for (ImportDeclaration removedImport : removedImports) {
            removedImport.remove();
        }
    }

    private void removeRedundantImports(CompilationUnit compilationUnit) {
        AstNodeCollection<ImportDeclaration> imports = compilationUnit.getImports();
        for (ImportDeclaration node : imports) {
            if (!StringUtilities.startsWith((CharSequence)node.getImport(), (CharSequence)"java.lang.")) continue;
            node.remove();
        }
    }
}

