/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.confighandler;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.xml.confighandler.XSLTParameter;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformation;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="xslt", namespace="http://windup.jboss.org/v1/xml")
public class XSLTTransformationHandler
implements ElementHandler<XSLTTransformation> {
    public XSLTTransformation processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String description = JOOX.$((Element)element).attr("description");
        String extension = JOOX.$((Element)element).attr("extension");
        String template = JOOX.$((Element)element).attr("template");
        String of = JOOX.$((Element)element).attr("of");
        if (StringUtils.isBlank((String)description)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'description' attribute");
        }
        if (StringUtils.isBlank((String)template)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'template' attribute");
        }
        if (StringUtils.isBlank((String)extension)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'extension' attribute");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        List children = JOOX.$((Element)element).children("xslt-parameter").get();
        for (Element child : children) {
            XSLTParameter param = (XSLTParameter)handlerManager.processElement(child);
            parameters.put(param.getKey(), param.getValue());
        }
        Path pathContainingXml = handlerManager.getXmlInputPath();
        if (pathContainingXml != null) {
            String fullPath = template.startsWith("/") || template.startsWith("\\") ? template : pathContainingXml.resolve(template).toAbsolutePath().toString();
            if (of != null) {
                return XSLTTransformation.of(of).usingFilesystem(fullPath).withDescription(description).withExtension(extension).withParameters(parameters);
            }
            return XSLTTransformation.usingFilesystem(fullPath).withDescription(description).withExtension(extension).withParameters(parameters);
        }
        ClassLoader xmlFileAddonClassLoader = handlerManager.getAddonContainingInputXML().getClassLoader();
        if (of != null) {
            return XSLTTransformation.of(of).using(template, xmlFileAddonClassLoader).withDescription(description).withExtension(extension).withParameters(parameters);
        }
        return XSLTTransformation.using(template, xmlFileAddonClassLoader).withDescription(description).withExtension(extension).withParameters(parameters);
    }
}

