/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class ClosestFirstIterator<V, E>
extends CrossComponentIterator<V, E, FibonacciHeapNode<QueueEntry<V, E>>> {
    private FibonacciHeap<QueueEntry<V, E>> heap = new FibonacciHeap();
    private double radius = Double.POSITIVE_INFINITY;
    private boolean initialized = false;

    public ClosestFirstIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public ClosestFirstIterator(Graph<V, E> graph, V v) {
        this(graph, v, Double.POSITIVE_INFINITY);
    }

    public ClosestFirstIterator(Graph<V, E> graph, V v, double d) {
        super(graph, v);
        this.radius = d;
        this.checkRadiusTraversal(this.isCrossComponentTraversal());
        this.initialized = true;
    }

    @Override
    public void setCrossComponentTraversal(boolean bl) {
        if (this.initialized) {
            this.checkRadiusTraversal(bl);
        }
        super.setCrossComponentTraversal(bl);
    }

    public double getShortestPathLength(V v) {
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v);
        if (fibonacciHeapNode == null) {
            return Double.POSITIVE_INFINITY;
        }
        return fibonacciHeapNode.getKey();
    }

    public E getSpanningTreeEdge(V v) {
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v);
        if (fibonacciHeapNode == null) {
            return null;
        }
        return ((QueueEntry)fibonacciHeapNode.getData()).spanningTreeEdge;
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        if (this.heap.size() == 0) {
            return true;
        }
        if (this.heap.min().getKey() > this.radius) {
            this.heap.clear();
            return true;
        }
        return false;
    }

    @Override
    protected void encounterVertex(V v, E e) {
        double d = e == null ? 0.0 : this.calculatePathLength(v, e);
        FibonacciHeapNode<QueueEntry<V, E>> fibonacciHeapNode = this.createSeenData(v, e);
        this.putSeenData(v, fibonacciHeapNode);
        this.heap.insert(fibonacciHeapNode, d);
    }

    @Override
    protected void encounterVertexAgain(V v, E e) {
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v);
        if (((QueueEntry)fibonacciHeapNode.getData()).frozen) {
            return;
        }
        double d = this.calculatePathLength(v, e);
        if (d < fibonacciHeapNode.getKey()) {
            ((QueueEntry)fibonacciHeapNode.getData()).spanningTreeEdge = e;
            this.heap.decreaseKey(fibonacciHeapNode, d);
        }
    }

    @Override
    protected V provideNextVertex() {
        FibonacciHeapNode<QueueEntry<V, E>> fibonacciHeapNode = this.heap.removeMin();
        fibonacciHeapNode.getData().frozen = true;
        return fibonacciHeapNode.getData().vertex;
    }

    private void assertNonNegativeEdge(E e) {
        if (this.getGraph().getEdgeWeight(e) < 0.0) {
            throw new IllegalArgumentException("negative edge weights not allowed");
        }
    }

    private double calculatePathLength(V v, E e) {
        this.assertNonNegativeEdge(e);
        Object v2 = Graphs.getOppositeVertex(this.getGraph(), e, v);
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v2);
        return fibonacciHeapNode.getKey() + this.getGraph().getEdgeWeight(e);
    }

    private void checkRadiusTraversal(boolean bl) {
        if (bl && this.radius != Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("radius may not be specified for cross-component traversal");
        }
    }

    private FibonacciHeapNode<QueueEntry<V, E>> createSeenData(V v, E e) {
        QueueEntry queueEntry = new QueueEntry();
        queueEntry.vertex = v;
        queueEntry.spanningTreeEdge = e;
        return new FibonacciHeapNode(queueEntry);
    }

    static class QueueEntry<V, E> {
        E spanningTreeEdge;
        V vertex;
        boolean frozen;

        QueueEntry() {
        }
    }
}

