/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ext.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.addons.AddonFilter;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.loader.WindupRuleProviderLoader;
import org.jboss.windup.ext.groovy.GroovyConfigContext;
import org.jboss.windup.ext.groovy.GroovyConfigMethod;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.FurnaceCompositeClassLoader;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;

public class GroovyWindupRuleProviderLoader
implements WindupRuleProviderLoader {
    private static final Logger LOG = Logging.get(GroovyWindupRuleProviderLoader.class);
    public static final String CURRENT_WINDUP_SCRIPT = "CURRENT_WINDUP_SCRIPT";
    private static final String GROOVY_RULES_EXTENSION = "windup.groovy";
    @Inject
    private FurnaceClasspathScanner scanner;
    @Inject
    private Furnace furnace;
    @Inject
    private Imported<GroovyConfigMethod> methods;

    public List<WindupRuleProvider> getProviders(final GraphContext context) {
        final ArrayList ruleProviders = new ArrayList();
        Binding binding = new Binding();
        binding.setVariable("windupRuleProviderBuilders", ruleProviders);
        binding.setVariable("supportFunctions", new HashMap());
        binding.setVariable("graphContext", (Object)context);
        GroovyConfigContext configContext = new GroovyConfigContext(){

            @Override
            public void addRuleProvider(WindupRuleProvider provider) {
                ruleProviders.add(provider);
            }

            @Override
            public GraphContext getGraphContext() {
                return context;
            }
        };
        for (GroovyConfigMethod method : this.methods) {
            binding.setVariable(method.getName(configContext), method.getClosure(configContext));
        }
        CompilerConfiguration config = new CompilerConfiguration();
        ClassLoader loader = this.getCompositeClassloader();
        GroovyShell shell = new GroovyShell(loader, binding, config);
        try {
            InputStream supportFuncsIS = this.getClass().getResourceAsStream("/org/jboss/windup/addon/groovy/WindupGroovySupportFunctions.groovy");
            Iterator<URL> iterator = null;
            try {
                InputStreamReader isr = new InputStreamReader(supportFuncsIS);
                shell.evaluate((Reader)isr);
            }
            catch (Throwable isr) {
                iterator = isr;
                throw isr;
            }
            finally {
                if (supportFuncsIS != null) {
                    if (iterator != null) {
                        try {
                            supportFuncsIS.close();
                        }
                        catch (Throwable isr) {
                            ((Throwable)((Object)iterator)).addSuppressed(isr);
                        }
                    } else {
                        supportFuncsIS.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WindupException("Failed to load support functions due to: " + e.getMessage(), (Throwable)e);
        }
        Map supportFunctions = (Map)binding.getVariable("supportFunctions");
        for (Map.Entry supportFunctionEntry : supportFunctions.entrySet()) {
            binding.setVariable((String)supportFunctionEntry.getKey(), supportFunctionEntry.getValue());
        }
        binding.setVariable("supportFunctions", null);
        for (URL resource : this.getScripts(context)) {
            try {
                InputStreamReader reader = new InputStreamReader(resource.openStream());
                Throwable throwable = null;
                try {
                    binding.setVariable(CURRENT_WINDUP_SCRIPT, (Object)resource.toExternalForm());
                    shell.evaluate((Reader)reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                throw new WindupException("Failed to evaluate configuration: ", (Throwable)e);
            }
        }
        List providers = (List)binding.getVariable("windupRuleProviderBuilders");
        return providers;
    }

    private ClassLoader getCompositeClassloader() {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        AddonFilter filter = new AddonFilter(){

            public boolean accept(Addon addon) {
                Set dependencies = addon.getDependencies();
                boolean found = false;
                for (AddonDependency dependency : dependencies) {
                    if (!dependency.getDependency().getId().getName().contains("groovy")) continue;
                    return true;
                }
                return false;
            }
        };
        for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(filter)) {
            loaders.add(addon.getClassLoader());
        }
        return new FurnaceCompositeClassLoader(this.getClass().getClassLoader(), loaders);
    }

    private Iterable<URL> getScripts(GraphContext context) {
        ArrayList<URL> results = new ArrayList<URL>();
        List scripts = this.scanner.scan(GROOVY_RULES_EXTENSION);
        results.addAll(scripts);
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        Iterable userRulesFileModels = cfg.getUserRulesPaths();
        for (FileModel fm : userRulesFileModels) {
            results.addAll(this.getScripts(fm));
        }
        return results;
    }

    private Collection<URL> getScripts(FileModel userRulesFileModel) {
        String userRulesDirectory = userRulesFileModel == null ? null : userRulesFileModel.getFilePath();
        Path userRulesPath = Paths.get(userRulesDirectory, new String[0]);
        if (!Files.isDirectory(userRulesPath, new LinkOption[0])) {
            LOG.warning("Not scanning: " + userRulesPath.normalize().toString() + " for rules as the directory could not be found!");
            return Collections.emptyList();
        }
        if (!Files.isDirectory(userRulesPath, new LinkOption[0])) {
            LOG.warning("Not scanning: " + userRulesPath.normalize().toString() + " for rules as the directory could not be read!");
            return Collections.emptyList();
        }
        final ArrayList<URL> results = new ArrayList<URL>();
        try {
            Files.walkFileTree(userRulesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(GroovyWindupRuleProviderLoader.GROOVY_RULES_EXTENSION)) {
                        results.add(file.toUri().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new WindupException("Failed to search userdir: \"" + userRulesPath + "\" for groovy rules due to: " + e.getMessage(), (Throwable)e);
        }
        return results;
    }
}

