/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public abstract class OncRpcServerStub {
    public OncRpcServerTransport[] transports;
    public OncRpcServerTransportRegistrationInfo[] info;
    protected Object shutdownSignal = new Object();
    private String characterEncoding;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws OncRpcException, IOException {
        try {
            this.unregister(this.transports);
        }
        catch (OncRpcException oncRpcException) {
            // empty catch block
        }
        this.register(this.transports);
        this.run(this.transports);
        try {
            this.unregister(this.transports);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.close(this.transports);
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.close(this.transports);
            return;
        }
    }

    public void register(OncRpcServerTransport[] transports) throws OncRpcException {
        int size = transports.length;
        int idx = 0;
        while (idx < size) {
            transports[idx].register();
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(OncRpcServerTransport[] transports) {
        int size = transports.length;
        int idx = 0;
        while (idx < size) {
            transports[idx].listen();
            ++idx;
        }
        while (true) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                try {
                    this.shutdownSignal.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRpcProcessing() {
        if (this.shutdownSignal != null) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                this.shutdownSignal.notify();
            }
        }
    }

    public void unregister(OncRpcServerTransport[] transports) throws OncRpcException {
        int size = transports.length;
        int idx = 0;
        while (idx < size) {
            transports[idx].unregister();
            ++idx;
        }
    }

    public void close(OncRpcServerTransport[] transports) {
        int size = transports.length;
        int idx = 0;
        while (idx < size) {
            transports[idx].close();
            ++idx;
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        int size = this.transports.length;
        int idx = 0;
        while (idx < size) {
            this.transports[idx].setCharacterEncoding(characterEncoding);
            ++idx;
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

