/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.PrintStream;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class CommandListCommand
extends AbstractShellCommand {
    @Inject
    private CommandFactory commandFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("command-list").description("List all available commands.");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Shell shell = (Shell)uiContext.getProvider();
        TerminalSize terminalSize = shell.getConsole().getShell().getSize();
        ArrayList<String> display = new ArrayList<String>();
        Iterable commands = this.commandFactory.getCommands();
        for (UICommand command : commands) {
            UICommandMetadata metadata = command.getMetadata(uiContext);
            String name = this.commandFactory.getCommandName(uiContext, command);
            boolean enabled = command.isEnabled(uiContext);
            display.add(metadata.getCategory() + " > " + new TerminalString(name, new TerminalColor(enabled ? Color.CYAN : Color.RED, Color.DEFAULT)).toString() + " - " + metadata.getDescription());
        }
        UIOutput output = uiContext.getProvider().getOutput();
        PrintStream out = output.out();
        out.println(Parser.formatDisplayList((String[])display.toArray(new String[display.size()]), (int)terminalSize.getHeight(), (int)terminalSize.getWidth()));
        return Results.success();
    }
}

