/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.regex.addons.tokens;

import com.googlecode.streamflyer.internal.thirdparty.ZzzValidate;
import com.googlecode.streamflyer.regex.MatchProcessor;
import com.googlecode.streamflyer.regex.ReplacingProcessor;
import com.googlecode.streamflyer.regex.addons.util.DoNothingProcessor;
import java.util.regex.Pattern;

public class Token {
    private String name;
    private String regex;
    private int capturingGroupCount;
    private MatchProcessor matchProcessor;

    public Token(String regex) {
        this("" + System.currentTimeMillis(), regex, new DoNothingProcessor());
    }

    public Token(String name, String regex) {
        this(name, regex, new DoNothingProcessor());
    }

    public Token(String name, String regex, String replacement) {
        this(name, regex, new ReplacingProcessor(replacement));
    }

    public Token(String name, String regex, MatchProcessor matchProcessor) {
        ZzzValidate.notNull(matchProcessor, "matchProcessor must not be null");
        this.name = name;
        this.regex = regex;
        this.matchProcessor = matchProcessor;
        this.capturingGroupCount = Pattern.compile(regex).matcher("").groupCount();
    }

    public String getName() {
        return this.name;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getCapturingGroupCount() {
        return this.capturingGroupCount;
    }

    public MatchProcessor getMatchProcessor() {
        return this.matchProcessor;
    }

    public String toString() {
        return "Token [name=" + this.name + ", regex=" + this.regex + ", capturingGroupCount=" + this.capturingGroupCount + ", matchProcessor=" + this.matchProcessor + "]";
    }
}

