/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.xml;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.core.Modifier;
import com.googlecode.streamflyer.internal.thirdparty.ZzzValidate;
import com.googlecode.streamflyer.util.ModificationFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InvalidXmlCharacterModifier
implements Modifier {
    public static final String XML_10_VERSION = "1.0";
    public static final String XML_11_VERSION = "1.1";
    protected ModificationFactory factory;
    protected String replacement;
    protected Matcher matcher;
    protected boolean dollarZero;

    public InvalidXmlCharacterModifier(String replacement, String xmlVersion) {
        this(8192, replacement, xmlVersion, replacement.contains("$0"));
    }

    public InvalidXmlCharacterModifier(int newNumberOfChars, String replacement, String xmlVersion, boolean dollarZero) {
        Pattern pattern;
        ZzzValidate.notNull(replacement, "replacement must not be null");
        ZzzValidate.notNull(xmlVersion, "xmlVersion must not be null");
        this.factory = new ModificationFactory(0, newNumberOfChars);
        this.replacement = replacement;
        this.dollarZero = dollarZero;
        if (XML_10_VERSION.equals(xmlVersion)) {
            pattern = Pattern.compile(this.getInvalidXmlCharacterRegex_Xml10());
        } else if (XML_11_VERSION.equals(xmlVersion)) {
            pattern = Pattern.compile(this.getInvalidXmlCharacterRegex_Xml11());
        } else {
            throw new IllegalArgumentException("xmlVersion has the illegal (or unsupported) value " + xmlVersion);
        }
        this.matcher = pattern.matcher("");
    }

    protected String getInvalidXmlCharacterRegex_Xml10() {
        return "[^\\u0020-\\uD7FF\\u0009\\u000A\\u000D\\uE000-\\uFFFD\\u10000-\\u10FFFF]";
    }

    protected String getInvalidXmlCharacterRegex_Xml11() {
        return "[^\\u0001-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]";
    }

    @Override
    public AfterModification modify(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        this.matcher.reset(characterBuffer);
        this.matcher.region(firstModifiableCharacterInBuffer, characterBuffer.length());
        int start = firstModifiableCharacterInBuffer;
        while (this.matcher.find(start)) {
            start = this.onMatch(characterBuffer);
        }
        return this.factory.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
    }

    protected int onMatch(StringBuilder characterBuffer) {
        String replacement_ = this.replacement(characterBuffer);
        characterBuffer.replace(this.matcher.start(), this.matcher.end(), replacement_);
        return this.matcher.start() + replacement_.length();
    }

    protected String replacement(StringBuilder characterBuffer) {
        if (this.dollarZero) {
            char ch = characterBuffer.charAt(this.matcher.start());
            String chHex = Integer.toString(ch, 16).toUpperCase();
            while (chHex.length() < 4) {
                chHex = "0" + chHex;
            }
            chHex = "U+" + chHex;
            return this.replacement.replace("$0", chHex);
        }
        return this.replacement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InvalidXmlCharacterModifier [\nreplacement=");
        builder.append(this.replacement);
        builder.append(", \nmatcher=");
        builder.append(this.matcher);
        builder.append(", \ndollarZero=");
        builder.append(this.dollarZero);
        builder.append("]");
        return builder.toString();
    }
}

